/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.assertions.impl;

import org.assertj.core.api.Condition;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public class Adapter {
    public static <T> Condition<? super T> fromInverseMatcher(Matcher<? extends T> matcher) {
        return Adapter.adaptMatcher(matcher, true);
    }

    public static <T> Condition<? super T> fromMatcher(Matcher<? extends T> matcher) {
        return Adapter.adaptMatcher(matcher, false);
    }

    private static <T> Condition<? super T> adaptMatcher(final Matcher<? extends T> matcher, final boolean invert) {
        return new Condition<T>(){

            public boolean matches(T t) {
                boolean matches = matcher.matches(t);
                if (invert) {
                    boolean bl = matches = !matches;
                }
                if (!matches) {
                    StringDescription reasonDescription = new StringDescription();
                    matcher.describeTo((Description)reasonDescription);
                    throw new AssertionError((Object)Adapter.getErrorMessage(matcher, t, invert));
                }
                return true;
            }
        };
    }

    private static <T> String getErrorMessage(Matcher<? extends T> matcher, T actual, boolean invert) {
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Expected: ");
        StringDescription reasonDescription = new StringDescription();
        matcher.describeTo((Description)reasonDescription);
        errorMessageBuilder.append(reasonDescription.toString()).append(invert ? " to be false" : "").append("\n     but: ").append(Adapter.getActual(matcher, actual));
        return errorMessageBuilder.toString();
    }

    private static <T> String getActual(Matcher<? extends T> matcher, T actual) {
        String actualStr = actual.toString();
        if (matcher instanceof TypeSafeMatcher) {
            TypeSafeMatcher typeSafeMatcher = (TypeSafeMatcher)matcher;
            StringDescription valueDescription = new StringDescription();
            typeSafeMatcher.describeMismatch(actual, (Description)valueDescription);
            actualStr = valueDescription.toString();
        }
        return actualStr;
    }
}

