/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.robot.impl;

import java.util.Objects;
import javafx.scene.input.MouseButton;
import org.testfx.robot.DragRobot;
import org.testfx.robot.MouseRobot;
import org.testfx.robot.MoveRobot;
import org.testfx.service.query.PointQuery;

public class DragRobotImpl
implements DragRobot {
    private final MouseRobot mouseRobot;
    private final MoveRobot moveRobot;

    public DragRobotImpl(MouseRobot mouseRobot, MoveRobot moveRobot) {
        Objects.requireNonNull(mouseRobot, "mouseRobot must not be null");
        Objects.requireNonNull(moveRobot, "moveRobot must not be null");
        this.mouseRobot = mouseRobot;
        this.moveRobot = moveRobot;
    }

    @Override
    public void drag(MouseButton ... buttons) {
        this.mouseRobot.press(buttons);
    }

    @Override
    public void drag(PointQuery pointQuery, MouseButton ... buttons) {
        this.moveRobot.moveTo(pointQuery);
        this.drag(buttons);
    }

    @Override
    public void drop() {
        this.mouseRobot.release(new MouseButton[0]);
    }

    @Override
    public void dropTo(PointQuery pointQuery) {
        this.moveRobot.moveTo(pointQuery);
        this.drop();
    }

    @Override
    public void dropBy(double x, double y) {
        this.moveRobot.moveBy(x, y);
        this.drop();
    }
}

