/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.adapter.impl;

import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import org.testfx.internal.JavaVersionAdapter;
import org.testfx.internal.PlatformAdapter;
import org.testfx.service.adapter.RobotAdapter;

public class AwtRobotAdapter
implements RobotAdapter<Robot> {
    private Robot awtRobot;

    @Override
    public void robotCreate() {
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            throw new RuntimeException("can not create awt robot as environment is headless");
        }
        Toolkit.getDefaultToolkit();
        this.awtRobot = this.createAwtRobot();
    }

    @Override
    public void robotDestroy() {
        this.awtRobot = null;
    }

    @Override
    public void keyPress(KeyCode key) {
        if (key == KeyCode.COMMAND) {
            key = KeyCode.META;
        }
        this.useRobot().keyPress(JavaVersionAdapter.convertToKeyCodeId(key));
    }

    @Override
    public void keyRelease(KeyCode key) {
        if (key == KeyCode.COMMAND) {
            key = KeyCode.META;
        }
        this.useRobot().keyRelease(JavaVersionAdapter.convertToKeyCodeId(key));
    }

    @Override
    public Point2D getMouseLocation() {
        Point awtPoint = MouseInfo.getPointerInfo().getLocation();
        return this.scaleInverseRect(new Point2D(awtPoint.getX(), awtPoint.getY()));
    }

    @Override
    public void mouseMove(Point2D location) {
        Rectangle2D scaled = this.scaleRect(new Rectangle2D(location.getX(), location.getY(), 0.0, 0.0));
        this.useRobot().mouseMove((int)scaled.getMinX(), (int)scaled.getMinY());
    }

    @Override
    public void mousePress(MouseButton button) {
        this.useRobot().mousePress(this.convertToAwtButton(button));
    }

    @Override
    public void mouseRelease(MouseButton button) {
        this.useRobot().mouseRelease(this.convertToAwtButton(button));
    }

    @Override
    public void mouseWheel(int wheelAmount) {
        this.useRobot().mouseWheel(wheelAmount);
    }

    @Override
    public Color getCapturePixelColor(Point2D location) {
        Rectangle2D region = new Rectangle2D(location.getX(), location.getY(), 2.0, 2.0);
        Image image = this.getCaptureRegion(region);
        return image.getPixelReader().getColor(0, 0);
    }

    @Override
    public Image getCaptureRegion(Rectangle2D region) {
        BufferedImage out;
        Rectangle2D scaled = this.scaleRect(region);
        Rectangle awtRectangle = new Rectangle((int)scaled.getMinX(), (int)scaled.getMinY(), (int)scaled.getWidth(), (int)scaled.getHeight());
        BufferedImage awtBufferedImage = this.useRobot().createScreenCapture(awtRectangle);
        if (this.scaleRequired()) {
            double scaleX = region.getWidth() / scaled.getWidth();
            double scaleY = region.getHeight() / scaled.getHeight();
            int w = (int)((double)awtBufferedImage.getWidth() * scaleX);
            int h = (int)((double)awtBufferedImage.getHeight() * scaleY);
            out = new BufferedImage(w, h, 2);
            AffineTransform at = new AffineTransform();
            at.scale(scaleX, scaleY);
            AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
            out = scaleOp.filter(awtBufferedImage, out);
        } else {
            out = awtBufferedImage;
        }
        return SwingFXUtils.toFXImage((BufferedImage)out, null);
    }

    public Image getCaptureRegionRaw(Rectangle2D region) {
        Rectangle2D scaled = this.scaleRect(region);
        Rectangle awtRectangle = new Rectangle((int)scaled.getMinX(), (int)scaled.getMinY(), (int)scaled.getWidth(), (int)scaled.getHeight());
        BufferedImage awtBufferedImage = this.useRobot().createScreenCapture(awtRectangle);
        return SwingFXUtils.toFXImage((BufferedImage)awtBufferedImage, null);
    }

    private Robot useRobot() {
        if (this.awtRobot == null) {
            this.robotCreate();
        }
        return this.awtRobot;
    }

    private Robot createAwtRobot() {
        try {
            return new Robot();
        }
        catch (AWTException exception) {
            throw new RuntimeException(exception);
        }
    }

    private int convertToAwtButton(MouseButton button) {
        switch (button) {
            case PRIMARY: {
                return 1024;
            }
            case MIDDLE: {
                return 2048;
            }
            case SECONDARY: {
                return 4096;
            }
        }
        throw new IllegalArgumentException("MouseButton: " + button + " not supported by awt robot");
    }

    private Rectangle2D scaleRect(Rectangle2D rect) {
        if (!this.scaleRequired()) {
            return rect;
        }
        double factorX = JavaVersionAdapter.getScreenScaleX();
        double factorY = JavaVersionAdapter.getScreenScaleY();
        return new Rectangle2D(rect.getMinX() * factorX, rect.getMinY() * factorY, rect.getWidth() * factorX, rect.getHeight() * factorY);
    }

    private Point2D scaleInverseRect(Point2D pt) {
        if (!this.scaleRequired()) {
            return pt;
        }
        double factorX = JavaVersionAdapter.getScreenScaleX();
        double factorY = JavaVersionAdapter.getScreenScaleY();
        return new Point2D(pt.getX() / factorX, pt.getY() / factorY);
    }

    private boolean scaleRequired() {
        if (JavaVersionAdapter.getScreenScaleX() == 1.0 && JavaVersionAdapter.getScreenScaleY() == 1.0) {
            return false;
        }
        if (Boolean.getBoolean("testfx.awt.scale")) {
            return true;
        }
        if (PlatformAdapter.getOs() == PlatformAdapter.OS.WINDOWS) {
            return false;
        }
        return PlatformAdapter.getOs() != PlatformAdapter.OS.MAC;
    }
}

