/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.support.impl;

import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import org.testfx.service.support.PixelMatcher;
import org.testfx.service.support.PixelMatcherResult;

public abstract class PixelMatcherBase
implements PixelMatcher {
    @Override
    public PixelMatcherResult match(Image image0, Image image1) {
        WritableImage matchImage = this.createEmptyMatchImage(image0, image1);
        int imageWidth = (int)matchImage.getWidth();
        int imageHeight = (int)matchImage.getHeight();
        long matchPixels = 0L;
        long totalPixels = imageWidth * imageHeight;
        for (int imageY = 0; imageY < imageHeight; ++imageY) {
            for (int imageX = 0; imageX < imageWidth; ++imageX) {
                Color color1;
                Color color0 = image0.getPixelReader().getColor(imageX, imageY);
                boolean areColorsMatching = this.matchColors(color0, color1 = image1.getPixelReader().getColor(imageX, imageY));
                if (areColorsMatching) {
                    ++matchPixels;
                    Color matchColor = this.createMatchColor(color0, color1);
                    matchImage.getPixelWriter().setColor(imageX, imageY, matchColor);
                    continue;
                }
                Color nonMatchColor = this.createNonMatchColor(color0, color1);
                matchImage.getPixelWriter().setColor(imageX, imageY, nonMatchColor);
            }
        }
        return new PixelMatcherResult((Image)matchImage, matchPixels, totalPixels);
    }
}

