/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.paint.Color;
import javafx.util.Pair;

public final class ColorUtils {
    private static final List<Pair<String, Color>> NAMED_COLORS = new ArrayList<Pair<String, Color>>(140);

    private ColorUtils() {
    }

    private static String getClosestNamedColor(int r, int g, int b) {
        ColorUtils.checkColorTriple(r, g, b);
        Pair<String, Color> closestColorPair = NAMED_COLORS.get(0);
        double minDistanceSeen = 2.147483647E9;
        for (Pair<String, Color> namedColorPair : NAMED_COLORS) {
            double distance = ColorUtils.calculateColorDistSq(Color.color((double)((double)r / 255.0), (double)((double)g / 255.0), (double)((double)b / 255.0)), (Color)namedColorPair.getValue());
            if (!(distance < minDistanceSeen)) continue;
            minDistanceSeen = distance;
            closestColorPair = namedColorPair;
        }
        return (String)closestColorPair.getKey();
    }

    public static String getClosestNamedColor(Integer hexColor) {
        Objects.requireNonNull(hexColor, "hexColor must not be null");
        int r = (hexColor & 0xFF0000) >> 16;
        int g = (hexColor & 0xFF00) >> 8;
        int b = hexColor & 0xFF;
        return ColorUtils.getClosestNamedColor(r, g, b);
    }

    public static Color getClosestNamedColor(Color color) {
        Objects.requireNonNull(color, "color must not be null");
        return Color.valueOf((String)ColorUtils.getClosestNamedColor((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0)));
    }

    private static Optional<String> getNamedColor(int r, int g, int b) {
        ColorUtils.checkColorTriple(r, g, b);
        for (Pair<String, Color> namedColorPair : NAMED_COLORS) {
            if (!Color.rgb((int)r, (int)g, (int)b).equals(namedColorPair.getValue())) continue;
            return Optional.of(namedColorPair.getKey());
        }
        return Optional.empty();
    }

    public static Optional<Color> getNamedColor(String name) {
        Objects.requireNonNull(name, "name must not be null");
        for (Pair<String, Color> namedColorPair : NAMED_COLORS) {
            if (!name.toUpperCase(Locale.US).equals(namedColorPair.getKey())) continue;
            return Optional.of(namedColorPair.getValue());
        }
        return Optional.empty();
    }

    public static Optional<Color> getNamedColor(Color color) {
        Objects.requireNonNull(color, "color must not be null");
        for (Pair<String, Color> namedColorPair : NAMED_COLORS) {
            if (!color.equals(namedColorPair.getValue())) continue;
            return Optional.of(namedColorPair.getValue());
        }
        return Optional.empty();
    }

    public static Optional<String> getNamedColor(Integer hexColor) {
        Objects.requireNonNull(hexColor, "hexColor must not be null");
        int r = (hexColor & 0xFF0000) >> 16;
        int g = (hexColor & 0xFF00) >> 8;
        int b = hexColor & 0xFF;
        return ColorUtils.getNamedColor(r, g, b);
    }

    public static double calculateColorDistSq(Color color0, Color color1) {
        Objects.requireNonNull(color0, "color0 must not be null");
        Objects.requireNonNull(color1, "color1 must not be null");
        double diffRed = color0.getRed() - color1.getRed();
        double diffGreen = color0.getGreen() - color1.getGreen();
        double diffBlue = color0.getBlue() - color1.getBlue();
        return diffRed * diffRed + diffGreen * diffGreen + diffBlue * diffBlue;
    }

    private static void checkColorTriple(int r, int g, int b) {
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("r must be in range [0, 255] but was: " + r);
        }
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("g must be in range [0, 255] but was: " + g);
        }
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("b must be in range [0, 255] but was: " + b);
        }
    }

    static {
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"ALICEBLUE", (Object)Color.ALICEBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"ANTIQUEWHITE", (Object)Color.ANTIQUEWHITE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"AQUA", (Object)Color.AQUA));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"AQUAMARINE", (Object)Color.AQUAMARINE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"AZURE", (Object)Color.AZURE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"BEIGE", (Object)Color.BEIGE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"BISQUE", (Object)Color.BISQUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"BLACK", (Object)Color.BLACK));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"BLANCHEDALMOND", (Object)Color.BLANCHEDALMOND));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"BLUE", (Object)Color.BLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"BLUEVIOLET", (Object)Color.BLUEVIOLET));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"BROWN", (Object)Color.BROWN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"BURLYWOOD", (Object)Color.BURLYWOOD));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"CADETBLUE", (Object)Color.CADETBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"CHARTREUSE", (Object)Color.CHARTREUSE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"CHOCOLATE", (Object)Color.CHOCOLATE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"CORAL", (Object)Color.CORAL));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"CORNFLOWERBLUE", (Object)Color.CORNFLOWERBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"CORNSILK", (Object)Color.CORNSILK));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"CRIMSON", (Object)Color.CRIMSON));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"CYAN", (Object)Color.CYAN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKBLUE", (Object)Color.DARKBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKCYAN", (Object)Color.DARKCYAN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKGOLDENROD", (Object)Color.DARKGOLDENROD));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKGRAY", (Object)Color.DARKGRAY));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKGREEN", (Object)Color.DARKGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKKHAKI", (Object)Color.DARKKHAKI));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKMAGENTA", (Object)Color.DARKMAGENTA));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKOLIVEGREEN", (Object)Color.DARKOLIVEGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKORANGE", (Object)Color.DARKORANGE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKORCHID", (Object)Color.DARKORCHID));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKRED", (Object)Color.DARKRED));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKSALMON", (Object)Color.DARKSALMON));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKSEAGREEN", (Object)Color.DARKSEAGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKSLATEBLUE", (Object)Color.DARKSLATEBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKSLATEGRAY", (Object)Color.DARKSLATEGRAY));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKTURQUOISE", (Object)Color.DARKTURQUOISE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DARKVIOLET", (Object)Color.DARKVIOLET));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DEEPPINK", (Object)Color.DEEPPINK));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DEEPSKYBLUE", (Object)Color.DEEPSKYBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DIMGRAY", (Object)Color.DIMGRAY));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"DODGERBLUE", (Object)Color.DODGERBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"FIREBRICK", (Object)Color.FIREBRICK));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"FLORALWHITE", (Object)Color.FLORALWHITE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"FORESTGREEN", (Object)Color.FORESTGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"FUCHSIA", (Object)Color.FUCHSIA));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"GAINSBORO", (Object)Color.GAINSBORO));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"GHOSTWHITE", (Object)Color.GHOSTWHITE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"GOLD", (Object)Color.GOLD));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"GOLDENROD", (Object)Color.GOLDENROD));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"GRAY", (Object)Color.GRAY));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"GREEN", (Object)Color.GREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"GREENYELLOW", (Object)Color.GREENYELLOW));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"HONEYDEW", (Object)Color.HONEYDEW));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"HOTPINK", (Object)Color.HOTPINK));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"INDIANRED", (Object)Color.INDIANRED));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"INDIGO", (Object)Color.INDIGO));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"IVORY", (Object)Color.IVORY));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"KHAKI", (Object)Color.KHAKI));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LAVENDER", (Object)Color.LAVENDER));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LAVENDERBLUSH", (Object)Color.LAVENDERBLUSH));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LAWNGREEN", (Object)Color.LAWNGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LEMONCHIFFON", (Object)Color.LEMONCHIFFON));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTBLUE", (Object)Color.LIGHTBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTCORAL", (Object)Color.LIGHTCORAL));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTCYAN", (Object)Color.LIGHTCYAN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTGOLDENRODYELLOW", (Object)Color.LIGHTGOLDENRODYELLOW));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTGRAY", (Object)Color.LIGHTGRAY));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTGREEN", (Object)Color.LIGHTGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTPINK", (Object)Color.LIGHTPINK));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTSALMON", (Object)Color.LIGHTSALMON));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTSEAGREEN", (Object)Color.LIGHTSEAGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTSKYBLUE", (Object)Color.LIGHTSKYBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTSLATEGRAY", (Object)Color.LIGHTSLATEGRAY));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTSTEELBLUE", (Object)Color.LIGHTSTEELBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIGHTYELLOW", (Object)Color.LIGHTYELLOW));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIME", (Object)Color.LIME));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LIMEGREEN", (Object)Color.LIMEGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"LINEN", (Object)Color.LINEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MAGENTA", (Object)Color.MAGENTA));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MAROON", (Object)Color.MAROON));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MEDIUMAQUAMARINE", (Object)Color.MEDIUMAQUAMARINE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MEDIUMBLUE", (Object)Color.MEDIUMBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MEDIUMORCHID", (Object)Color.MEDIUMORCHID));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MEDIUMPURPLE", (Object)Color.MEDIUMPURPLE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MEDIUMSEAGREEN", (Object)Color.MEDIUMSEAGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MEDIUMSLATEBLUE", (Object)Color.MEDIUMSLATEBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MEDIUMSPRINGGREEN", (Object)Color.MEDIUMSPRINGGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MEDIUMTURQUOISE", (Object)Color.MEDIUMTURQUOISE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MEDIUMVIOLETRED", (Object)Color.MEDIUMVIOLETRED));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MIDNIGHTBLUE", (Object)Color.MIDNIGHTBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MINTCREAM", (Object)Color.MINTCREAM));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MISTYROSE", (Object)Color.MISTYROSE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"MOCCASIN", (Object)Color.MOCCASIN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"NAVAJOWHITE", (Object)Color.NAVAJOWHITE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"NAVY", (Object)Color.NAVY));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"OLDLACE", (Object)Color.OLDLACE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"OLIVE", (Object)Color.OLIVE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"OLIVEDRAB", (Object)Color.OLIVEDRAB));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"ORANGE", (Object)Color.ORANGE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"ORANGERED", (Object)Color.ORANGERED));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"ORCHID", (Object)Color.ORCHID));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PALEGOLDENROD", (Object)Color.PALEGOLDENROD));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PALEGREEN", (Object)Color.PALEGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PALETURQUOISE", (Object)Color.PALETURQUOISE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PALEVIOLETRED", (Object)Color.PALEVIOLETRED));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PAPAYAWHIP", (Object)Color.PAPAYAWHIP));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PEACHPUFF", (Object)Color.PEACHPUFF));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PERU", (Object)Color.PERU));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PINK", (Object)Color.PINK));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PLUM", (Object)Color.PLUM));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"POWDERBLUE", (Object)Color.POWDERBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"PURPLE", (Object)Color.PURPLE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"RED", (Object)Color.RED));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"ROSYBROWN", (Object)Color.ROSYBROWN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"ROYALBLUE", (Object)Color.ROYALBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SADDLEBROWN", (Object)Color.SADDLEBROWN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SALMON", (Object)Color.SALMON));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SANDYBROWN", (Object)Color.SANDYBROWN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SEAGREEN", (Object)Color.SEAGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SEASHELL", (Object)Color.SEASHELL));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SIENNA", (Object)Color.SIENNA));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SILVER", (Object)Color.SILVER));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SKYBLUE", (Object)Color.SKYBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SLATEBLUE", (Object)Color.SLATEBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SLATEGRAY", (Object)Color.SLATEGRAY));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SNOW", (Object)Color.SNOW));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"SPRINGGREEN", (Object)Color.SPRINGGREEN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"STEELBLUE", (Object)Color.STEELBLUE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"TAN", (Object)Color.TAN));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"TEAL", (Object)Color.TEAL));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"THISTLE", (Object)Color.THISTLE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"TOMATO", (Object)Color.TOMATO));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"TURQUOISE", (Object)Color.TURQUOISE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"VIOLET", (Object)Color.VIOLET));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"WHEAT", (Object)Color.WHEAT));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"WHITE", (Object)Color.WHITE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"WHITESMOKE", (Object)Color.WHITESMOKE));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"YELLOW", (Object)Color.YELLOW));
        NAMED_COLORS.add((Pair<String, Color>)new Pair((Object)"YELLOWGREEN", (Object)Color.YELLOWGREEN));
    }
}

