/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import springfox.documentation.service.Documentation;

public class DocumentationCache {
    private Map<String, Documentation> documentationLookup = new LinkedHashMap<String, Documentation>();
    private Map<String, Object> serializedDocumentationLookup = new LinkedHashMap<String, Object>();

    public void addDocumentation(Documentation documentation) {
        this.documentationLookup.put(documentation.getGroupName(), documentation);
    }

    public void addSerializedDocumentation(String groupName, Object serialized) {
        this.serializedDocumentationLookup.put(groupName, serialized);
    }

    public Documentation documentationByGroup(String groupName) {
        return this.documentationLookup.get(groupName);
    }

    public <T> T getSerializedDocumentationByGroup(String groupName, Class<T> clazz) {
        Object serialized = this.serializedDocumentationLookup.get(groupName);
        if (serialized != null && clazz.isAssignableFrom(serialized.getClass())) {
            return (T)serialized;
        }
        return null;
    }

    public Map<String, Documentation> all() {
        return Collections.unmodifiableMap(this.documentationLookup);
    }

    public Map<String, Object> allSerialized() {
        return Collections.unmodifiableMap(this.serializedDocumentationLookup);
    }

    public void clear() {
        this.documentationLookup.clear();
        this.serializedDocumentationLookup.clear();
    }
}

