/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.io.ISVNLockHandler;

public class FSFS {
    public static final String SVN_REPOS_DB_DIR = "db";
    public static final String TXN_PATH_EXT = ".txn";
    public static final String TXN_PATH_EXT_CHILDREN = ".children";
    public static final String PATH_PREFIX_NODE = "node.";
    public static final String TXN_PATH_EXT_PROPS = ".props";
    public static final int DIGEST_SUBDIR_LEN = 3;
    public static final String SVN_OPAQUE_LOCK_TOKEN = "opaquelocktoken:";
    public static final String TXN_PATH_REV = "rev";
    public static final String PATH_LOCK_KEY = "path";
    public static final String CHILDREN_LOCK_KEY = "children";
    public static final String TOKEN_LOCK_KEY = "token";
    public static final String OWNER_LOCK_KEY = "owner";
    public static final String IS_DAV_COMMENT_LOCK_KEY = "is_dav_comment";
    public static final String CREATION_DATE_LOCK_KEY = "creation_date";
    public static final String EXPIRATION_DATE_LOCK_KEY = "expiration_date";
    public static final String COMMENT_LOCK_KEY = "comment";
    private static final int REPOSITORY_FORMAT = 5;
    private static final int DB_FORMAT = 2;
    private static final String DB_TYPE = "fsfs";
    private int myDBFormat;
    private int myReposFormat;
    private String myUUID;
    private File myRepositoryRoot;
    private File myRevisionsRoot;
    private File myRevisionPropertiesRoot;
    private File myTransactionsRoot;
    private File myLocksRoot;
    private File myDBRoot;
    private File myWriteLockFile;
    private File myCurrentFile;

    public FSFS(File repositoryRoot) {
        this.myRepositoryRoot = repositoryRoot;
        this.myDBRoot = new File(this.myRepositoryRoot, SVN_REPOS_DB_DIR);
        this.myRevisionsRoot = new File(this.myDBRoot, "revs");
        this.myRevisionPropertiesRoot = new File(this.myDBRoot, "revprops");
        this.myTransactionsRoot = new File(this.myDBRoot, "transactions");
        this.myWriteLockFile = new File(this.myDBRoot, "write-lock");
        this.myLocksRoot = new File(this.myDBRoot, "locks");
    }

    public int getDBFormat() {
        return this.myDBFormat;
    }

    public int getReposFormat() {
        return this.myReposFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws SVNException {
        File dbCurrentFile;
        SVNErrorMessage err;
        FSFile formatFile = new FSFile(new File(this.myRepositoryRoot, "format"));
        int format = -1;
        try {
            format = formatFile.readInt();
        }
        finally {
            formatFile.close();
        }
        if (format > 5) {
            err = SVNErrorMessage.create(SVNErrorCode.REPOS_UNSUPPORTED_VERSION, "Expected format ''{0,number,integer}'' of repository; found format ''{1,number,integer}''", new Object[]{new Integer(5), new Integer(format)});
            SVNErrorManager.error(err);
        }
        this.myReposFormat = format;
        formatFile = new FSFile(new File(this.myDBRoot, "format"));
        try {
            format = formatFile.readInt();
        }
        catch (SVNException svne) {
            if (svne.getCause() instanceof FileNotFoundException) {
                format = 2;
            }
        }
        finally {
            formatFile.close();
        }
        if (format > 2) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_UNSUPPORTED_FORMAT, "Expected FS format ''{0,number,integer}''; found format ''{1,number,integer}''", new Object[]{new Integer(2), new Integer(format)});
            SVNErrorManager.error(err);
        }
        this.myDBFormat = format;
        formatFile = new FSFile(new File(this.myDBRoot, "fs-type"));
        String fsType = null;
        try {
            fsType = formatFile.readLine(128);
        }
        finally {
            formatFile.close();
        }
        if (!DB_TYPE.equals(fsType)) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.FS_UNKNOWN_FS_TYPE, "Unsupported fs type ''{0}''", fsType);
            SVNErrorManager.error(err2);
        }
        if (!(dbCurrentFile = this.getCurrentFile()).exists() || !dbCurrentFile.canRead()) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can''t open file ''{0}''", dbCurrentFile);
            SVNErrorManager.error(err3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUUID() throws SVNException {
        if (this.myUUID == null) {
            FSFile formatFile = new FSFile(new File(this.myDBRoot, "uuid"));
            try {
                this.myUUID = formatFile.readLine(38);
            }
            finally {
                formatFile.close();
            }
        }
        return this.myUUID;
    }

    public File getWriteLockFile() {
        return this.myWriteLockFile;
    }

    public long getDatedRevision(Date date) throws SVNException {
        long latest;
        long top = latest = this.getYoungestRevision();
        long bottom = 0L;
        Date currentTime = null;
        while (bottom <= top) {
            long middle = (top + bottom) / 2L;
            currentTime = this.getRevisionTime(middle);
            if (currentTime.compareTo(date) > 0) {
                if (middle - 1L < 0L) {
                    return 0L;
                }
                Date prevTime = this.getRevisionTime(middle - 1L);
                if (prevTime.compareTo(date) < 0) {
                    return middle - 1L;
                }
                top = middle - 1L;
                continue;
            }
            if (currentTime.compareTo(date) < 0) {
                if (middle + 1L > latest) {
                    return latest;
                }
                Date nextTime = this.getRevisionTime(middle + 1L);
                if (nextTime.compareTo(date) > 0) {
                    return middle + 1L;
                }
                bottom = middle + 1L;
                continue;
            }
            return middle;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getYoungestRevision() throws SVNException {
        FSFile file = new FSFile(this.getCurrentFile());
        try {
            String line = file.readLine(180);
            int spaceIndex = line.indexOf(32);
            if (spaceIndex > 0) {
                long l = Long.parseLong(line.substring(0, spaceIndex));
                return l;
            }
        }
        catch (NumberFormatException nfe) {
        }
        finally {
            file.close();
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Can''t parse revision number in file ''{0}''", file);
        SVNErrorManager.error(err);
        return -1L;
    }

    public File getDBRoot() {
        return this.myDBRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRevisionProperties(long revision) throws SVNException {
        FSFile file = new FSFile(this.getRevisionPropertiesFile(revision));
        try {
            Map map = file.readProperties(false);
            return map;
        }
        finally {
            file.close();
        }
    }

    public FSRevisionRoot createRevisionRoot(long revision) {
        return new FSRevisionRoot(this, revision);
    }

    public FSTransactionRoot createTransactionRoot(String txnId) throws SVNException {
        Map txnProps = this.getTransactionProperties(txnId);
        int flags = 0;
        if (txnProps.get("svn:check-ood") != null) {
            flags |= 1;
        }
        if (txnProps.get("svn:check-locks") != null) {
            flags |= 2;
        }
        return new FSTransactionRoot(this, txnId, flags);
    }

    public FSTransactionInfo openTxn(String txnName) throws SVNException {
        SVNFileType kind = SVNFileType.getType(this.getTransactionDir(txnName));
        if (kind != SVNFileType.DIRECTORY) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_TRANSACTION, "No such transaction");
            SVNErrorManager.error(err);
        }
        FSTransactionRoot txnRoot = new FSTransactionRoot(this, txnName, 0);
        FSTransactionInfo localTxn = txnRoot.getTxn();
        return new FSTransactionInfo(localTxn.getBaseRevision(), txnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSRevisionNode getRevisionNode(FSID id) throws SVNException {
        FSFile revisionFile = null;
        if (id.isTxn()) {
            File file = new File(this.getTransactionDir(id.getTxnID()), PATH_PREFIX_NODE + id.getNodeID() + "." + id.getCopyID());
            revisionFile = new FSFile(file);
        } else {
            revisionFile = this.getRevisionFile(id.getRevision());
            revisionFile.seek(id.getOffset());
        }
        Map headers = null;
        try {
            headers = revisionFile.readHeader();
        }
        finally {
            revisionFile.close();
        }
        return FSRevisionNode.fromMap(headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDirContents(FSRevisionNode revNode) throws SVNException {
        if (revNode.getTextRepresentation() != null && revNode.getTextRepresentation().isTxn()) {
            FSFile childrenFile = this.getTransactionRevisionNodeChildrenFile(revNode.getId());
            Map entries = null;
            try {
                Map rawEntries = childrenFile.readProperties(false);
                rawEntries.putAll(childrenFile.readProperties(true));
                Object[] keys = rawEntries.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    if (rawEntries.get(keys[i]) != null) continue;
                    rawEntries.remove(keys[i]);
                }
                entries = this.parsePlainRepresentation(rawEntries, true);
            }
            finally {
                childrenFile.close();
            }
            return entries;
        }
        if (revNode.getTextRepresentation() != null) {
            FSRepresentation textRep = revNode.getTextRepresentation();
            FSFile revisionFile = null;
            try {
                revisionFile = this.openAndSeekRepresentation(textRep);
                String repHeader = revisionFile.readLine(160);
                if (!"PLAIN".equals(repHeader)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                    SVNErrorManager.error(err);
                }
                revisionFile.resetDigest();
                Map rawEntries = revisionFile.readProperties(false);
                String checksum = revisionFile.digest();
                if (!checksum.equals(textRep.getHexDigest())) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Checksum mismatch while reading representation:\n   expected:  {0}\n     actual:  {1}", new Object[]{checksum, textRep.getHexDigest()});
                    SVNErrorManager.error(err);
                }
                Map map = this.parsePlainRepresentation(rawEntries, false);
                return map;
            }
            finally {
                if (revisionFile != null) {
                    revisionFile.close();
                }
            }
        }
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getProperties(FSRevisionNode revNode) throws SVNException {
        if (revNode.getPropsRepresentation() != null && revNode.getPropsRepresentation().isTxn()) {
            FSFile propsFile = null;
            try {
                propsFile = this.getTransactionRevisionNodePropertiesFile(revNode.getId());
                Map map = propsFile.readProperties(false);
                return map;
            }
            finally {
                if (propsFile != null) {
                    propsFile.close();
                }
            }
        }
        if (revNode.getPropsRepresentation() != null) {
            FSRepresentation propsRep = revNode.getPropsRepresentation();
            FSFile revisionFile = null;
            try {
                revisionFile = this.openAndSeekRepresentation(propsRep);
                String repHeader = revisionFile.readLine(160);
                if (!"PLAIN".equals(repHeader)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                    SVNErrorManager.error(err);
                }
                revisionFile.resetDigest();
                Map props = revisionFile.readProperties(false);
                String checksum = revisionFile.digest();
                if (!checksum.equals(propsRep.getHexDigest())) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Checksum mismatch while reading representation:\n   expected:  {0}\n     actual:  {1}", new Object[]{checksum, propsRep.getHexDigest()});
                    SVNErrorManager.error(err);
                }
                Map map = props;
                return map;
            }
            finally {
                if (revisionFile != null) {
                    revisionFile.close();
                }
            }
        }
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNextRevisionIDs() throws SVNException {
        SVNErrorMessage err;
        int spaceInd;
        String[] ids = new String[2];
        FSFile currentFile = new FSFile(this.getCurrentFile());
        String idsLine = null;
        try {
            idsLine = currentFile.readLine(80);
        }
        finally {
            currentFile.close();
        }
        if (idsLine == null || idsLine.length() == 0) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt current file");
            SVNErrorManager.error(err2);
        }
        if ((spaceInd = idsLine.indexOf(32)) == -1) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt current file");
            SVNErrorManager.error(err);
        }
        if ((spaceInd = (idsLine = idsLine.substring(spaceInd + 1)).indexOf(32)) == -1) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt current file");
            SVNErrorManager.error(err);
        }
        String nodeID = idsLine.substring(0, spaceInd);
        String copyID = idsLine.substring(spaceInd + 1);
        ids[0] = nodeID;
        ids[1] = copyID;
        return ids;
    }

    public Map listTransactions() {
        HashMap<String, File> result = new HashMap<String, File>();
        File txnsDir = this.getTransactionsParentDir();
        File[] entries = SVNFileListUtil.listFiles(txnsDir);
        for (int i = 0; i < entries.length; ++i) {
            File entry = entries[i];
            if (entry.getName().length() <= TXN_PATH_EXT.length() || !entry.getName().endsWith(TXN_PATH_EXT)) continue;
            String txnName = entry.getName().substring(0, entry.getName().lastIndexOf(TXN_PATH_EXT));
            result.put(txnName, entry);
        }
        return result;
    }

    public File getNewRevisionFile(long revision) throws SVNException {
        File revFile = new File(this.myRevisionsRoot, String.valueOf(revision));
        if (revFile.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CONFLICT, "Revision already exists");
            SVNErrorManager.error(err);
        }
        return revFile;
    }

    public File getNewRevisionPropertiesFile(long revision) throws SVNException {
        File revPropsFile = new File(this.myRevisionPropertiesRoot, String.valueOf(revision));
        if (revPropsFile.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CONFLICT, "Revision already exists");
            SVNErrorManager.error(err);
        }
        return revPropsFile;
    }

    public File getTransactionDir(String txnID) {
        return new File(this.getTransactionsParentDir(), txnID + TXN_PATH_EXT);
    }

    public File getTransactionsParentDir() {
        return this.myTransactionsRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUUID(String uuid) throws SVNException {
        File uuidFile = new File(this.myDBRoot, "uuid");
        File uniqueFile = SVNFileUtil.createUniqueFile(this.myDBRoot, "uuid", ".tmp");
        uuid = uuid + '\n';
        OutputStream uuidOS = null;
        try {
            uuidOS = SVNFileUtil.openFileForWriting(uniqueFile);
            uuidOS.write(uuid.getBytes("US-ASCII"));
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing repository UUID to ''{0}''", uuidFile);
            err.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage()));
            SVNErrorManager.error(err);
        }
        finally {
            SVNFileUtil.closeFile(uuidOS);
        }
        SVNFileUtil.rename(uniqueFile, uuidFile);
    }

    public File getRevisionPropertiesFile(long revision) throws SVNException {
        File file = new File(this.myRevisionPropertiesRoot, String.valueOf(revision));
        if (!file.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0,number,integer}", new Long(revision));
            SVNErrorManager.error(err);
        }
        return file;
    }

    public File getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public FSFile openAndSeekRepresentation(FSRepresentation rep) throws SVNException {
        if (!rep.isTxn()) {
            return this.openAndSeekRevision(rep.getRevision(), rep.getOffset());
        }
        return this.openAndSeekTransaction(rep);
    }

    public File getNextIDsFile(String txnID) {
        return new File(this.getTransactionDir(txnID), "next-ids");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNextIDs(String txnID, String nodeID, String copyID) throws SVNException {
        OutputStream nextIdsFile = null;
        try {
            nextIdsFile = SVNFileUtil.openFileForWriting(this.getNextIDsFile(txnID));
            String ids = nodeID + " " + copyID + "\n";
            nextIdsFile.write(ids.getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, ioe);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(nextIdsFile);
                throw throwable;
            }
            SVNFileUtil.closeFile(nextIdsFile);
        }
        SVNFileUtil.closeFile(nextIdsFile);
    }

    public void setTransactionProperty(String txnID, String propertyName, String propertyValue) throws SVNException {
        SVNProperties revProps = new SVNProperties(this.getTransactionPropertiesFile(txnID), null);
        revProps.setPropertyValue(propertyName, propertyValue);
    }

    public void setRevisionProperty(long revision, String propertyName, String propertyValue) throws SVNException {
        SVNProperties revProps = new SVNProperties(this.getRevisionPropertiesFile(revision), null);
        revProps.setPropertyValue(propertyName, propertyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getTransactionProperties(String txnID) throws SVNException {
        FSFile txnPropsFile = new FSFile(this.getTransactionPropertiesFile(txnID));
        try {
            Map map = txnPropsFile.readProperties(false);
            return map;
        }
        finally {
            txnPropsFile.close();
        }
    }

    public File getTransactionPropertiesFile(String txnID) {
        return new File(this.getTransactionDir(txnID), "props");
    }

    public void createNewTxnNodeRevisionFromRevision(String txnID, FSRevisionNode sourceNode) throws SVNException {
        if (sourceNode.getId().isTxn()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Copying from transactions not allowed");
            SVNErrorManager.error(err);
        }
        FSRevisionNode revNode = FSRevisionNode.dumpRevisionNode(sourceNode);
        revNode.setPredecessorId(sourceNode.getId());
        revNode.setCount(revNode.getCount() + 1L);
        revNode.setCopyFromPath(null);
        revNode.setCopyFromRevision(-1L);
        revNode.setId(FSID.createTxnId(sourceNode.getId().getNodeID(), sourceNode.getId().getCopyID(), txnID));
        this.putTxnRevisionNode(revNode.getId(), revNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTxnRevisionNode(FSID id, FSRevisionNode revNode) throws SVNException {
        if (!id.isTxn()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Attempted to write to non-transaction");
            SVNErrorManager.error(err);
        }
        OutputStream revNodeFile = null;
        try {
            revNodeFile = SVNFileUtil.openFileForWriting(this.getTransactionRevNodeFile(id));
            this.writeTxnNodeRevision(revNodeFile, revNode);
        }
        catch (IOException ioe) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, ioe);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(revNodeFile);
                throw throwable;
            }
            SVNFileUtil.closeFile(revNodeFile);
        }
        SVNFileUtil.closeFile(revNodeFile);
    }

    public File getTransactionRevNodeFile(FSID id) {
        return new File(this.getTransactionDir(id.getTxnID()), PATH_PREFIX_NODE + id.getNodeID() + "." + id.getCopyID());
    }

    public void writeTxnNodeRevision(OutputStream revNodeFile, FSRevisionNode revNode) throws IOException {
        String id = "id: " + revNode.getId() + "\n";
        revNodeFile.write(id.getBytes("UTF-8"));
        String type = "type: " + revNode.getType() + "\n";
        revNodeFile.write(type.getBytes("UTF-8"));
        if (revNode.getPredecessorId() != null) {
            String predId = "pred: " + revNode.getPredecessorId() + "\n";
            revNodeFile.write(predId.getBytes("UTF-8"));
        }
        String count = "count: " + revNode.getCount() + "\n";
        revNodeFile.write(count.getBytes("UTF-8"));
        if (revNode.getTextRepresentation() != null) {
            String textRepresentation = "text: " + (revNode.getTextRepresentation().getTxnId() != null && revNode.getType() == SVNNodeKind.DIR ? "-1" : revNode.getTextRepresentation().toString()) + "\n";
            revNodeFile.write(textRepresentation.getBytes("UTF-8"));
        }
        if (revNode.getPropsRepresentation() != null) {
            String propsRepresentation = "props: " + (revNode.getPropsRepresentation().getTxnId() != null ? "-1" : revNode.getPropsRepresentation().toString()) + "\n";
            revNodeFile.write(propsRepresentation.getBytes("UTF-8"));
        }
        String cpath = "cpath: " + revNode.getCreatedPath() + "\n";
        revNodeFile.write(cpath.getBytes("UTF-8"));
        if (revNode.getCopyFromPath() != null) {
            String copyFromPath = "copyfrom: " + revNode.getCopyFromRevision() + " " + revNode.getCopyFromPath() + "\n";
            revNodeFile.write(copyFromPath.getBytes("UTF-8"));
        }
        if (revNode.getCopyRootRevision() != revNode.getId().getRevision() || !revNode.getCopyRootPath().equals(revNode.getCreatedPath())) {
            String copyroot = "copyroot: " + revNode.getCopyRootRevision() + " " + revNode.getCopyRootPath() + "\n";
            revNodeFile.write(copyroot.getBytes("UTF-8"));
        }
        revNodeFile.write("\n".getBytes("UTF-8"));
    }

    public SVNLock getLock(String repositoryPath, boolean haveWriteLock) throws SVNException {
        SVNLock lock = this.fetchLockFromDigestFile(null, repositoryPath, null);
        if (lock == null) {
            SVNErrorManager.error(FSErrors.errorNoSuchLock(repositoryPath, this));
        }
        Date current = new Date(System.currentTimeMillis());
        if (lock.getExpirationDate() != null && current.compareTo(lock.getExpirationDate()) > 0) {
            if (haveWriteLock) {
                this.deleteLock(lock);
            }
            SVNErrorManager.error(FSErrors.errorLockExpired(lock.getID(), this));
        }
        return lock;
    }

    public void deleteLock(SVNLock lock) throws SVNException {
        String reposPath = lock.getPath();
        String childToKill = null;
        ArrayList children = new ArrayList();
        while (true) {
            this.fetchLockFromDigestFile(null, reposPath, children);
            if (childToKill != null) {
                children.remove(childToKill);
            }
            if (children.size() == 0) {
                childToKill = this.getDigestFromRepositoryPath(reposPath);
                File digestFile = this.getDigestFileFromRepositoryPath(reposPath);
                SVNFileUtil.deleteFile(digestFile);
            } else {
                this.writeDigestLockFile(null, children, reposPath);
                childToKill = null;
            }
            if ("/".equals(reposPath)) break;
            if ("".equals(reposPath = SVNPathUtil.removeTail(reposPath))) {
                reposPath = "/";
            }
            children.clear();
        }
    }

    public void walkDigestFiles(File digestFile, ISVNLockHandler getLocksHandler, boolean haveWriteLock) throws SVNException {
        LinkedList children = new LinkedList();
        SVNLock lock = this.fetchLockFromDigestFile(digestFile, null, children);
        if (lock != null) {
            Date current = new Date(System.currentTimeMillis());
            if (lock.getExpirationDate() == null || current.compareTo(lock.getExpirationDate()) < 0) {
                getLocksHandler.handleLock(null, lock, null);
            } else if (haveWriteLock) {
                this.deleteLock(lock);
            }
        }
        if (children.isEmpty()) {
            return;
        }
        Iterator entries = children.iterator();
        while (entries.hasNext()) {
            String digestName = (String)entries.next();
            File parent = new File(this.myLocksRoot, digestName.substring(0, 3));
            File childDigestFile = new File(parent, digestName);
            this.walkDigestFiles(childDigestFile, getLocksHandler, haveWriteLock);
        }
    }

    public SVNLock getLockHelper(String repositoryPath, boolean haveWriteLock) throws SVNException {
        SVNLock lock = null;
        try {
            lock = this.getLock(repositoryPath, haveWriteLock);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_LOCK || svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_LOCK_EXPIRED) {
                return null;
            }
            throw svne;
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock fetchLockFromDigestFile(File digestFile, String repositoryPath, Collection children) throws SVNException {
        File digestLockFile = digestFile == null ? this.getDigestFileFromRepositoryPath(repositoryPath) : digestFile;
        Map lockProps = null;
        if (digestLockFile.exists()) {
            FSFile reader = new FSFile(digestLockFile);
            try {
                lockProps = reader.readProperties(false);
            }
            catch (SVNException svne) {
                SVNErrorMessage err = svne.getErrorMessage().wrap("Can't parse lock/entries hashfile ''{0}''", digestLockFile);
                SVNErrorManager.error(err);
            }
            finally {
                reader.close();
            }
        } else {
            lockProps = Collections.EMPTY_MAP;
        }
        SVNLock lock = null;
        String lockPath = (String)lockProps.get(PATH_LOCK_KEY);
        if (lockPath != null) {
            String creationTime;
            String davComment;
            String lockOwner;
            String lockToken = (String)lockProps.get(TOKEN_LOCK_KEY);
            if (lockToken == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(lockPath, this));
            }
            if ((lockOwner = (String)lockProps.get(OWNER_LOCK_KEY)) == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(lockPath, this));
            }
            if ((davComment = (String)lockProps.get(IS_DAV_COMMENT_LOCK_KEY)) == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(lockPath, this));
            }
            if ((creationTime = (String)lockProps.get(CREATION_DATE_LOCK_KEY)) == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(lockPath, this));
            }
            Date creationDate = SVNTimeUtil.parseDateString(creationTime);
            String expirationTime = (String)lockProps.get(EXPIRATION_DATE_LOCK_KEY);
            Date expirationDate = null;
            if (expirationTime != null) {
                expirationDate = SVNTimeUtil.parseDateString(expirationTime);
            }
            String comment = (String)lockProps.get(COMMENT_LOCK_KEY);
            lock = new SVNLock(lockPath, lockToken, lockOwner, comment, creationDate, expirationDate);
        }
        String childEntries = (String)lockProps.get(CHILDREN_LOCK_KEY);
        if (children != null && childEntries != null) {
            String[] digests = childEntries.split("\n");
            for (int i = 0; i < digests.length; ++i) {
                children.add(digests[i]);
            }
        }
        return lock;
    }

    public File getDigestFileFromRepositoryPath(String repositoryPath) throws SVNException {
        String digest = this.getDigestFromRepositoryPath(repositoryPath);
        File parent = new File(this.myLocksRoot, digest.substring(0, 3));
        return new File(parent, digest);
    }

    public String getDigestFromRepositoryPath(String repositoryPath) throws SVNException {
        MessageDigest digestFromPath = null;
        try {
            digestFromPath = MessageDigest.getInstance("MD5");
            digestFromPath.update(repositoryPath.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException nsae) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", nsae.getLocalizedMessage());
            SVNErrorManager.error(err, nsae);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
        return SVNFileUtil.toHexDigest(digestFromPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockPath(String path, String token, String username, boolean breakLock, boolean enableHooks) throws SVNException {
        FSWriteLock writeLock;
        String[] paths = new String[]{path};
        if (!breakLock && username == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "Cannot unlock path ''{0}'', no authenticated username available", path);
            SVNErrorManager.error(err);
        }
        if (enableHooks) {
            FSHooks.runPreUnlockHook(this.myRepositoryRoot, path, username);
        }
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLock(this);
        synchronized (fSWriteLock) {
            try {
                writeLock.lock();
                this.unlock(path, token, username, breakLock);
            }
            finally {
                writeLock.unlock();
                FSWriteLock.realease(writeLock);
            }
        }
        if (enableHooks) {
            try {
                FSHooks.runPostUnlockHook(this.myRepositoryRoot, paths, username);
            }
            catch (SVNException svne) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_UNLOCK_HOOK_FAILED, "Unlock succeeded, but post-unlock hook failed");
                err.setChildErrorMessage(svne.getErrorMessage());
                SVNErrorManager.error(err, svne);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock lockPath(String path, String token, String username, String comment, Date expirationDate, long currentRevision, boolean stealLock) throws SVNException {
        FSWriteLock writeLock;
        String[] paths = new String[]{path};
        if (username == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "Cannot lock path ''{0}'', no authenticated username available.", path);
            SVNErrorManager.error(err);
        }
        FSHooks.runPreLockHook(this.myRepositoryRoot, path, username);
        SVNLock lock = null;
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLock(this);
        synchronized (fSWriteLock) {
            try {
                writeLock.lock();
                lock = this.lock(path, token, username, comment, expirationDate, currentRevision, stealLock);
            }
            finally {
                writeLock.unlock();
                FSWriteLock.realease(writeLock);
            }
        }
        try {
            FSHooks.runPostLockHook(this.myRepositoryRoot, paths, username);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_LOCK_HOOK_FAILED, "Lock succeeded, but post-lock hook failed");
            err.setChildErrorMessage(svne.getErrorMessage());
            SVNErrorManager.error(err, svne);
        }
        return lock;
    }

    public Map compoundMetaProperties(long revision) throws SVNException {
        HashMap<String, String> metaProps = new HashMap<String, String>();
        Map revProps = this.getRevisionProperties(revision);
        String author = (String)revProps.get("svn:author");
        String date = (String)revProps.get("svn:date");
        String uuid = this.getUUID();
        String rev = String.valueOf(revision);
        metaProps.put("svn:entry:last-author", author);
        metaProps.put("svn:entry:committed-date", date);
        metaProps.put("svn:entry:committed-rev", rev);
        metaProps.put("svn:entry:uuid", uuid);
        return metaProps;
    }

    public static File findRepositoryRoot(File path) {
        if (path == null) {
            path = new File("");
        }
        File rootPath = path;
        while (!FSFS.isRepositoryRoot(rootPath)) {
            if ((rootPath = rootPath.getParentFile()) != null) continue;
            return null;
        }
        return rootPath;
    }

    protected FSFile getTransactionRevisionPrototypeFile(String txnID) {
        File revFile = new File(this.getTransactionDir(txnID), TXN_PATH_REV);
        return new FSFile(revFile);
    }

    protected FSFile getTransactionChangesFile(String txnID) {
        File file = new File(this.getTransactionDir(txnID), "changes");
        return new FSFile(file);
    }

    protected FSFile getTransactionRevisionNodeChildrenFile(FSID txnID) {
        File childrenFile = new File(this.getTransactionDir(txnID.getTxnID()), PATH_PREFIX_NODE + txnID.getNodeID() + "." + txnID.getCopyID() + TXN_PATH_EXT_CHILDREN);
        return new FSFile(childrenFile);
    }

    protected FSFile getRevisionFile(long revision) throws SVNException {
        File revisionFile = new File(this.myRevisionsRoot, String.valueOf(revision));
        if (!revisionFile.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0,number,integer}", new Long(revision));
            SVNErrorManager.error(err);
        }
        return new FSFile(revisionFile);
    }

    protected FSFile getTransactionRevisionNodePropertiesFile(FSID id) {
        File revNodePropsFile = new File(this.getTransactionDir(id.getTxnID()), PATH_PREFIX_NODE + id.getNodeID() + "." + id.getCopyID() + TXN_PATH_EXT_PROPS);
        return new FSFile(revNodePropsFile);
    }

    protected File getCurrentFile() {
        if (this.myCurrentFile == null) {
            this.myCurrentFile = new File(this.myDBRoot, "current");
        }
        return this.myCurrentFile;
    }

    private void unlock(String path, String token, String username, boolean breakLock) throws SVNException {
        SVNLock lock = this.getLock(path, true);
        if (!breakLock) {
            if (token == null || !token.equals(lock.getID())) {
                SVNErrorManager.error(FSErrors.errorNoSuchLock(lock.getPath(), this));
            }
            if (username == null || "".equals(username)) {
                SVNErrorManager.error(FSErrors.errorNoUser(this));
            }
            if (!username.equals(lock.getOwner())) {
                SVNErrorManager.error(FSErrors.errorLockOwnerMismatch(username, lock.getOwner(), this));
            }
        }
        this.deleteLock(lock);
    }

    private SVNLock lock(String path, String token, String username, String comment, Date expirationDate, long currentRevision, boolean stealLock) throws SVNException {
        SVNLock existingLock;
        long youngestRev = this.getYoungestRevision();
        FSRevisionRoot root = this.createRevisionRoot(youngestRev);
        SVNNodeKind kind = root.checkNodeKind(path);
        if (kind == SVNNodeKind.DIR) {
            SVNErrorManager.error(FSErrors.errorNotFile(path, this));
        } else if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' doesn't exist in HEAD revision", path);
            SVNErrorManager.error(err);
        }
        if (username == null || "".equals(username)) {
            SVNErrorManager.error(FSErrors.errorNoUser(this));
        }
        if (FSRepository.isValidRevision(currentRevision)) {
            SVNErrorMessage err;
            FSRevisionNode node = root.getRevisionNode(path);
            long createdRev = node.getId().getRevision();
            if (FSRepository.isInvalidRevision(createdRev)) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Path ''{0}'' doesn't exist in HEAD revision", path);
                SVNErrorManager.error(err);
            }
            if (currentRevision < createdRev) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Lock failed: newer version of ''{0}'' exists", path);
                SVNErrorManager.error(err);
            }
        }
        if ((existingLock = this.getLockHelper(path, true)) != null) {
            if (!stealLock) {
                SVNErrorManager.error(FSErrors.errorPathAlreadyLocked(existingLock.getPath(), existingLock.getOwner(), this));
            } else {
                this.deleteLock(existingLock);
            }
        }
        SVNLock lock = null;
        if (token == null) {
            String uuid = SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
            token = SVN_OPAQUE_LOCK_TOKEN + uuid;
            lock = new SVNLock(path, token, username, comment, new Date(System.currentTimeMillis()), expirationDate);
        } else {
            lock = new SVNLock(path, token, username, comment, new Date(System.currentTimeMillis()), expirationDate);
        }
        this.setLock(lock);
        return lock;
    }

    private void setLock(SVNLock lock) throws SVNException {
        if (lock == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: attempted to set a null lock");
            SVNErrorManager.error(err);
        }
        String lastChild = "";
        String path = lock.getPath();
        ArrayList<String> children = new ArrayList<String>();
        while (true) {
            String digestFileName = this.getDigestFromRepositoryPath(path);
            SVNLock fetchedLock = this.fetchLockFromDigestFile(null, path, children);
            if (lock != null) {
                fetchedLock = lock;
                lock = null;
                lastChild = digestFileName;
            } else {
                if (!children.isEmpty() && children.contains(lastChild)) break;
                children.add(lastChild);
            }
            this.writeDigestLockFile(fetchedLock, children, path);
            if ("/".equals(path)) break;
            if ("".equals(path = SVNPathUtil.removeTail(path))) {
                path = "/";
            }
            children.clear();
        }
    }

    private boolean ensureDirExists(File dir, boolean create) {
        if (!dir.exists() && create) {
            return dir.mkdirs();
        }
        return dir.exists();
    }

    private void writeDigestLockFile(SVNLock lock, Collection children, String repositoryPath) throws SVNException {
        if (!this.ensureDirExists(this.myLocksRoot, true)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Can't create a directory at ''{0}''", this.myLocksRoot);
            SVNErrorManager.error(err);
        }
        File digestLockFile = this.getDigestFileFromRepositoryPath(repositoryPath);
        String digest = this.getDigestFromRepositoryPath(repositoryPath);
        File lockDigestSubdir = new File(this.myLocksRoot, digest.substring(0, 3));
        if (!this.ensureDirExists(lockDigestSubdir, true)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Can't create a directory at ''{0}''", lockDigestSubdir);
            SVNErrorManager.error(err);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (lock != null) {
            props.put(PATH_LOCK_KEY, lock.getPath());
            props.put(OWNER_LOCK_KEY, lock.getOwner());
            props.put(TOKEN_LOCK_KEY, lock.getID());
            props.put(IS_DAV_COMMENT_LOCK_KEY, "0");
            if (lock.getComment() != null) {
                props.put(COMMENT_LOCK_KEY, lock.getComment());
            }
            if (lock.getCreationDate() != null) {
                props.put(CREATION_DATE_LOCK_KEY, SVNTimeUtil.formatDate(lock.getCreationDate()));
            }
            if (lock.getExpirationDate() != null) {
                props.put(EXPIRATION_DATE_LOCK_KEY, SVNTimeUtil.formatDate(lock.getExpirationDate()));
            }
        }
        if (children != null && children.size() > 0) {
            Object[] digests = children.toArray();
            StringBuffer value = new StringBuffer();
            for (int i = 0; i < digests.length; ++i) {
                value.append(digests[i]);
                value.append('\n');
            }
            props.put(CHILDREN_LOCK_KEY, value.toString());
        }
        try {
            SVNProperties.setProperties(props, digestLockFile, SVNFileUtil.createUniqueFile(digestLockFile.getParentFile(), digestLockFile.getName(), ".tmp"), "END");
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Cannot write lock/entries hashfile ''{0}''", digestLockFile);
            SVNErrorManager.error(err, svne);
        }
    }

    private FSFile openAndSeekTransaction(FSRepresentation rep) {
        FSFile file = this.getTransactionRevisionPrototypeFile(rep.getTxnId());
        file.seek(rep.getOffset());
        return file;
    }

    private FSFile openAndSeekRevision(long revision, long offset) throws SVNException {
        FSFile file = this.getRevisionFile(revision);
        file.seek(offset);
        return file;
    }

    private Map parsePlainRepresentation(Map entries, boolean mayContainNulls) throws SVNException {
        HashMap<String, FSEntry> representationMap = new HashMap<String, FSEntry>();
        Object[] names = entries.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            String name = (String)names[i];
            String unparsedEntry = (String)entries.get(names[i]);
            if (unparsedEntry == null && mayContainNulls) continue;
            FSEntry nextRepEntry = this.parseRepEntryValue(name, unparsedEntry);
            if (nextRepEntry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Directory entry corrupt");
                SVNErrorManager.error(err);
            }
            representationMap.put(name, nextRepEntry);
        }
        return representationMap;
    }

    private FSEntry parseRepEntryValue(String name, String value) {
        if (value == null) {
            return null;
        }
        int spaceInd = value.indexOf(32);
        if (spaceInd == -1) {
            return null;
        }
        String kind = value.substring(0, spaceInd);
        String rawID = value.substring(spaceInd + 1);
        SVNNodeKind type = SVNNodeKind.parseKind(kind);
        FSID id = FSID.fromString(rawID);
        if (type != SVNNodeKind.DIR && type != SVNNodeKind.FILE || id == null) {
            return null;
        }
        return new FSEntry(id, type, name);
    }

    private Date getRevisionTime(long revision) throws SVNException {
        Map revisionProperties = this.getRevisionProperties(revision);
        String timeString = (String)revisionProperties.get("svn:date");
        if (timeString == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Failed to find time on revision {0,number,integer}", new Long(revision));
            SVNErrorManager.error(err);
        }
        return SVNTimeUtil.parseDateString(timeString);
    }

    private static boolean isRepositoryRoot(File candidatePath) {
        File formatFile = new File(candidatePath, "format");
        SVNFileType fileType = SVNFileType.getType(formatFile);
        if (fileType != SVNFileType.FILE) {
            return false;
        }
        File dbFile = new File(candidatePath, SVN_REPOS_DB_DIR);
        fileType = SVNFileType.getType(dbFile);
        return fileType == SVNFileType.DIRECTORY || fileType == SVNFileType.SYMLINK;
    }
}

