/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

public class SVNPathUtil {
    public static final Comparator PATH_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getClass() != (class$java$lang$String == null ? (class$java$lang$String = SVNPathUtil.class$("java.lang.String")) : class$java$lang$String) || o2.getClass() != (class$java$lang$String == null ? (class$java$lang$String = SVNPathUtil.class$("java.lang.String")) : class$java$lang$String)) {
                return o1.getClass() == o2.getClass() ? 0 : (o1.getClass() == (class$java$lang$String == null ? (class$java$lang$String = SVNPathUtil.class$("java.lang.String")) : class$java$lang$String) ? 1 : -1);
            }
            String p1 = (String)o1;
            String p2 = (String)o2;
            return p1.replace('/', '\u0000').toLowerCase().compareTo(p2.toLowerCase().replace('/', '\u0000'));
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    public static String append(String f, String s) {
        char ch;
        int i;
        f = f == null ? "" : f;
        s = s == null ? "" : s;
        int l1 = f.length();
        int l2 = s.length();
        char[] r = new char[l1 + l2 + 2];
        int index = 0;
        for (i = 0; i < l1; ++i) {
            ch = f.charAt(i);
            if (i + 1 == l1 && ch == '/') break;
            r[index++] = ch;
        }
        for (i = 0; i < l2; ++i) {
            ch = s.charAt(i);
            if (i == 0 && ch != '/' && index > 0) {
                r[index++] = 47;
            }
            if (i + 1 == l2 && ch == '/') break;
            r[index++] = ch;
        }
        return new String(r, 0, index);
    }

    public static boolean isSinglePathComponent(String name) {
        if (name == null || "".equals(name) || "..".equals(name)) {
            return true;
        }
        return name.indexOf(47) == -1;
    }

    public static String concatToAbs(String f, String s) throws SVNException {
        SVNErrorMessage err;
        f = f == null || "".equals(f) ? "/" : f;
        String string = s = s == null ? "" : s;
        if (!SVNPathUtil.isCanonical(f)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "path component ''{0}'' is not canonical", f);
            SVNErrorManager.error(err);
        }
        if (!SVNPathUtil.isCanonical(s)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "path component ''{0}'' is not canonical", s);
            SVNErrorManager.error(err);
        }
        if ("/".equals(f)) {
            if (s.startsWith("/")) {
                return s;
            }
            return "/" + s;
        }
        return SVNPathUtil.append(f, s);
    }

    public static boolean isCanonical(String path) {
        return !(path == null || path.length() == 1 && path.charAt(0) == '.' || path.length() > 1 && path.charAt(path.length() - 1) == '/');
    }

    public static String removeTail(String path) {
        for (int index = path.length() - 1; index >= 0; --index) {
            if (path.charAt(index) != '/') continue;
            return path.substring(0, index);
        }
        return "";
    }

    public static String getCommonPathAncestor(String path1, String path2) {
        int index;
        if (path1 == null || path2 == null) {
            return null;
        }
        path1 = path1.replace(File.separatorChar, '/');
        path2 = path2.replace(File.separatorChar, '/');
        int separatorIndex = 0;
        for (index = 0; index < path1.length() && index < path2.length() && path1.charAt(index) == path2.charAt(index); ++index) {
            if (path1.charAt(index) != '/') continue;
            separatorIndex = index;
        }
        if (index == path1.length() && index == path2.length()) {
            return path1;
        }
        if (index == path1.length() && path2.charAt(index) == '/') {
            return path1;
        }
        if (index == path2.length() && path1.charAt(index) == '/') {
            return path2;
        }
        return path1.substring(0, separatorIndex);
    }

    public static String canonicalizeAbsPath(String path) {
        if (path == null) {
            return null;
        }
        if ("".equals(path)) {
            return "/";
        }
        StringBuffer newString = new StringBuffer();
        if (!path.startsWith("/")) {
            newString.append('/');
        }
        boolean eatingSlashes = false;
        for (int count = 0; count < path.length(); ++count) {
            if (path.charAt(count) == '/') {
                if (eatingSlashes) continue;
                eatingSlashes = true;
            } else if (eatingSlashes) {
                eatingSlashes = false;
            }
            newString.append(path.charAt(count));
        }
        if (newString.length() > 1 && newString.charAt(newString.length() - 1) == '/') {
            newString.deleteCharAt(newString.length() - 1);
        }
        return newString.toString();
    }

    public static void checkPathIsValid(String path) throws SVNException {
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (!SVNEncodingUtil.isASCIIControlChar(ch)) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid control character ''{0}'' in path ''{1}''", new String[]{"''0x" + SVNFormatUtil.getHexNumberFromByte((byte)ch) + "''", path});
            SVNErrorManager.error(err);
        }
    }

    public static String getCommonURLAncestor(String url1, String url2) {
        int index;
        if (url1 == null || url2 == null) {
            return null;
        }
        StringBuffer protocol = new StringBuffer();
        for (index = 0; index < url1.length() && index < url2.length(); ++index) {
            char ch1 = url1.charAt(index);
            if (ch1 != url2.charAt(index)) {
                return "";
            }
            if (ch1 == ':') break;
            protocol.append(ch1);
        }
        protocol.append("://");
        if ((index += 3) >= url1.length() || index >= url2.length()) {
            return "";
        }
        protocol.append(SVNPathUtil.getCommonPathAncestor(url1.substring(index), url2.substring(index)));
        return protocol.toString();
    }

    public static String condenceURLs(String[] urls, Collection condencedPaths, boolean removeRedundantURLs) {
        String url;
        int i;
        if (urls == null || urls.length == 0) {
            return null;
        }
        if (urls.length == 1) {
            return urls[0];
        }
        String rootURL = urls[0];
        for (i = 0; i < urls.length; ++i) {
            url = urls[i];
            rootURL = SVNPathUtil.getCommonURLAncestor(rootURL, url);
        }
        if (condencedPaths != null && removeRedundantURLs) {
            for (i = 0; i < urls.length; ++i) {
                String url1 = urls[i];
                if (url1 == null) continue;
                for (int j = 0; j < urls.length; ++j) {
                    String common;
                    String url2;
                    if (i == j || (url2 = urls[j]) == null || "".equals(common = SVNPathUtil.getCommonURLAncestor(url1, url2)) || common == null) continue;
                    if (common.equals(url1)) {
                        urls[j] = null;
                        continue;
                    }
                    if (!common.equals(url2)) continue;
                    urls[i] = null;
                }
            }
            for (int j = 0; j < urls.length; ++j) {
                url = urls[j];
                if (url == null || !url.equals(rootURL)) continue;
                urls[j] = null;
            }
        }
        if (condencedPaths != null) {
            for (i = 0; i < urls.length; ++i) {
                url = urls[i];
                if (url == null) continue;
                if (rootURL != null && !"".equals(rootURL) && (url = url.substring(rootURL.length())).startsWith("/")) {
                    url = url.substring(1);
                }
                condencedPaths.add(url);
            }
        }
        return rootURL;
    }

    public static String condencePaths(String[] paths, Collection condencedPaths, boolean removeRedundantPaths) {
        String path;
        int i;
        if (paths == null || paths.length == 0) {
            return null;
        }
        if (paths.length == 1) {
            return paths[0];
        }
        String rootPath = paths[0];
        for (i = 0; i < paths.length; ++i) {
            String url = paths[i];
            rootPath = SVNPathUtil.getCommonPathAncestor(rootPath, url);
        }
        if (condencedPaths != null && removeRedundantPaths) {
            for (i = 0; i < paths.length; ++i) {
                String path1 = paths[i];
                if (path1 == null) continue;
                for (int j = 0; j < paths.length; ++j) {
                    String common;
                    String path2;
                    if (i == j || (path2 = paths[j]) == null || "".equals(common = SVNPathUtil.getCommonPathAncestor(path1, path2)) || common == null) continue;
                    if (common.equals(path1)) {
                        paths[j] = null;
                        continue;
                    }
                    if (!common.equals(path2)) continue;
                    paths[i] = null;
                }
            }
            for (int j = 0; j < paths.length; ++j) {
                path = paths[j];
                if (path == null || !path.equals(rootPath)) continue;
                paths[j] = null;
            }
        }
        if (condencedPaths != null) {
            for (i = 0; i < paths.length; ++i) {
                path = paths[i];
                if (path == null) continue;
                if (rootPath != null && !"".equals(rootPath) && (path = path.substring(rootPath.length())).startsWith("/")) {
                    path = path.substring(1);
                }
                condencedPaths.add(path);
            }
        }
        return rootPath;
    }

    public static String validateFilePath(String path) {
        path = path.replace(File.separatorChar, '/');
        StringBuffer result = new StringBuffer();
        LinkedList<String> segments = new LinkedList<String>();
        Object tokens = new StringTokenizer(path, "/", false);
        while (((StringTokenizer)tokens).hasMoreTokens()) {
            String segment = ((StringTokenizer)tokens).nextToken();
            if ("..".equals(segment)) {
                if (!segments.isEmpty()) {
                    segments.remove(segments.size() - 1);
                    continue;
                }
                File root = new File(System.getProperty("user.dir"));
                while (root.getParentFile() != null) {
                    segments.add(0, root.getParentFile().getName());
                    root = root.getParentFile();
                }
                continue;
            }
            if (".".equals(segment) || segment.length() == 0) continue;
            segments.add(segment);
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            result.append("/");
        }
        if (path.length() > 1 && path.charAt(1) == '/') {
            result.append("/");
        }
        tokens = segments.iterator();
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            result.append(token);
            if (!tokens.hasNext()) continue;
            result.append('/');
        }
        return result.toString();
    }

    public static boolean isChildOf(File parentFile, File childFile) {
        if (parentFile == null || childFile == null) {
            return false;
        }
        parentFile = new File(SVNPathUtil.validateFilePath(parentFile.getAbsolutePath()));
        for (childFile = new File(SVNPathUtil.validateFilePath(childFile.getParentFile().getAbsolutePath())); childFile != null; childFile = childFile.getParentFile()) {
            if (!childFile.equals(parentFile)) continue;
            return true;
        }
        return false;
    }

    public static String tail(String path) {
        int index = path.length() - 1;
        if (index >= 0 && index < path.length() && path.charAt(index) == '/') {
            --index;
        }
        for (int i = index; i >= 0; --i) {
            if (path.charAt(i) != '/') continue;
            return path.substring(i + 1, index + 1);
        }
        return path;
    }

    public static String head(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            return path.substring(0, i);
        }
        return path;
    }

    public static String removeHead(String path) {
        for (int i = 0; i < path.length(); ++i) {
            int ind;
            if (path.charAt(i) != '/') continue;
            for (ind = i; ind < path.length() && path.charAt(ind) == '/'; ++ind) {
            }
            return path.substring(ind);
        }
        return "";
    }

    public static int getSegmentsCount(String path) {
        int count = path.length() > 0 ? 1 : 0;
        for (int i = 1; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++count;
        }
        return count;
    }

    public static boolean isAncestor(String parentPath, String ancestorPath) {
        parentPath = parentPath == null ? "" : parentPath;
        String string = ancestorPath = ancestorPath == null ? "" : ancestorPath;
        if (parentPath.length() == 0) {
            return !ancestorPath.startsWith("/");
        }
        if (ancestorPath.startsWith(parentPath)) {
            return parentPath.length() == ancestorPath.length() || parentPath.endsWith("/") || ancestorPath.charAt(parentPath.length()) == '/';
        }
        return false;
    }

    public static String pathIsChild(String path, String pathChild) {
        if (path == null || pathChild == null) {
            return null;
        }
        if (pathChild.compareTo(path) == 0) {
            return null;
        }
        int count = 0;
        for (count = 0; count < path.length() && count < pathChild.length(); ++count) {
            if (path.charAt(count) == pathChild.charAt(count)) continue;
            return null;
        }
        if (count == path.length() && count < pathChild.length()) {
            if (pathChild.charAt(count) == '/') {
                return pathChild.substring(count + 1);
            }
            if (count == 1 && path.charAt(0) == '/') {
                return pathChild.substring(1);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

