/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;

public class SVNCancellableOutputStream
extends FilterOutputStream {
    private ISVNEventHandler myEventHandler;

    public SVNCancellableOutputStream(OutputStream out, ISVNEventHandler eventHandler) {
        super(out == null ? SVNFileUtil.DUMMY_OUT : out);
        this.myEventHandler = eventHandler;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.myEventHandler != null) {
            try {
                this.myEventHandler.checkCancelled();
            }
            catch (SVNCancelException e) {
                throw new IOCancelException(e.getMessage());
            }
        }
        this.out.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        if (this.myEventHandler != null) {
            try {
                this.myEventHandler.checkCancelled();
            }
            catch (SVNCancelException e) {
                throw new IOCancelException(e.getMessage());
            }
        }
        this.out.write(b);
    }

    public static class IOCancelException
    extends IOException {
        public IOCancelException(String message) {
            super(message);
        }
    }
}

