/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;

public class SVNExportEditor
implements ISVNEditor {
    private File myRoot;
    private boolean myIsForce;
    private String myEOLStyle;
    private File myCurrentDirectory;
    private File myCurrentFile;
    private File myCurrentTmpFile;
    private String myCurrentPath;
    private Map myExternals;
    private Map myFileProperties;
    private ISVNEventHandler myEventDispatcher;
    private String myURL;
    private ISVNOptions myOptions;
    private SVNDeltaProcessor myDeltaProcessor;
    private String myChecksum;

    public SVNExportEditor(ISVNEventHandler eventDispatcher, String url, File dstPath, boolean force, String eolStyle, ISVNOptions options) {
        this.myRoot = dstPath;
        this.myIsForce = force;
        this.myEOLStyle = eolStyle;
        this.myExternals = new HashMap();
        this.myEventDispatcher = eventDispatcher;
        this.myURL = url;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myOptions = options;
    }

    public Map getCollectedExternals() {
        return this.myExternals;
    }

    public void openRoot(long revision) throws SVNException {
        this.addDir("", null, -1L);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentDirectory = new File(this.myRoot, path);
        this.myCurrentPath = path;
        SVNFileType dirType = SVNFileType.getType(this.myCurrentDirectory);
        if (dirType == SVNFileType.FILE || dirType == SVNFileType.SYMLINK) {
            if (!this.myIsForce) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' exists and is not a directory", this.myCurrentDirectory);
                SVNErrorManager.error(err);
            } else {
                SVNFileUtil.deleteAll(this.myCurrentDirectory, this.myEventDispatcher);
            }
        } else if (dirType == SVNFileType.DIRECTORY && !this.myIsForce) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists", this.myCurrentDirectory);
            SVNErrorManager.error(err);
        } else if (dirType == SVNFileType.NONE && !this.myCurrentDirectory.mkdirs()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "Cannot create directory ''{0}''", this.myCurrentDirectory);
            SVNErrorManager.error(err);
        }
        this.myEventDispatcher.handleEvent(SVNEventFactory.createExportAddedEvent(this.myRoot, this.myCurrentDirectory, SVNNodeKind.DIR), -1.0);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        if ("svn:externals".equals(name) && value != null) {
            this.myExternals.put(this.myCurrentDirectory, value);
        }
    }

    public void closeDir() throws SVNException {
        this.myCurrentDirectory = this.myCurrentDirectory.getParentFile();
        this.myCurrentPath = SVNPathUtil.tail(this.myCurrentPath);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        File file = new File(this.myRoot, path);
        if (!this.myIsForce && file.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "File ''{0}'' already exists", file);
            SVNErrorManager.error(err);
        }
        this.myCurrentFile = file;
        this.myFileProperties = new HashMap();
        this.myChecksum = null;
    }

    public void changeFileProperty(String commitPath, String name, String value) throws SVNException {
        this.myFileProperties.put(name, value);
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        this.myCurrentTmpFile = SVNFileUtil.createUniqueFile(this.myCurrentDirectory, ".export", ".tmp");
        this.myDeltaProcessor.applyTextDelta(null, this.myCurrentTmpFile, true);
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
        this.myChecksum = this.myDeltaProcessor.textDeltaEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        if (textChecksum == null) {
            textChecksum = (String)this.myFileProperties.get("svn:entry:checksum");
        }
        if (this.myIsForce) {
            this.myCurrentFile.delete();
        }
        String realChecksum = this.myChecksum != null ? this.myChecksum : SVNFileUtil.computeChecksum(this.myCurrentTmpFile);
        this.myChecksum = null;
        if (textChecksum != null && !textChecksum.equals(realChecksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", new Object[]{this.myCurrentFile, textChecksum, realChecksum});
            SVNErrorManager.error(err);
        }
        try {
            boolean executable;
            String date = (String)this.myFileProperties.get("svn:entry:committed-date");
            boolean special = this.myFileProperties.get("svn:special") != null;
            boolean binary = SVNProperty.isBinaryMimeType((String)this.myFileProperties.get("svn:mime-type"));
            String keywords = (String)this.myFileProperties.get("svn:keywords");
            Map keywordsMap = null;
            if (keywords != null) {
                String url = SVNPathUtil.append(this.myURL, SVNEncodingUtil.uriEncode(this.myCurrentPath));
                url = SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(this.myCurrentFile.getName()));
                String author = (String)this.myFileProperties.get("svn:entry:last-author");
                String revStr = (String)this.myFileProperties.get("svn:entry:committed-rev");
                keywordsMap = SVNTranslator.computeKeywords(keywords, url, author, date, revStr, this.myOptions);
            }
            byte[] eolBytes = null;
            if ("native".equals(this.myFileProperties.get("svn:eol-style"))) {
                eolBytes = SVNTranslator.getWorkingEOL(this.myEOLStyle != null ? this.myEOLStyle : (String)this.myFileProperties.get("svn:eol-style"));
            } else if (this.myFileProperties.containsKey("svn:eol-style")) {
                eolBytes = SVNTranslator.getWorkingEOL((String)this.myFileProperties.get("svn:eol-style"));
            }
            if (binary) {
                eolBytes = null;
                keywordsMap = null;
            }
            if (eolBytes != null || keywordsMap != null && !keywordsMap.isEmpty() || special) {
                SVNTranslator.translate(this.myCurrentTmpFile, this.myCurrentFile, eolBytes, keywordsMap, special, true);
            } else {
                SVNFileUtil.rename(this.myCurrentTmpFile, this.myCurrentFile);
            }
            boolean bl = executable = this.myFileProperties.get("svn:executable") != null;
            if (executable) {
                SVNFileUtil.setExecutable(this.myCurrentFile, true);
            }
            if (!special && date != null) {
                this.myCurrentFile.setLastModified(SVNTimeUtil.parseDate(date).getTime());
            }
            this.myEventDispatcher.handleEvent(SVNEventFactory.createExportAddedEvent(this.myRoot, this.myCurrentFile, SVNNodeKind.FILE), -1.0);
        }
        finally {
            this.myCurrentTmpFile.delete();
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void deleteEntry(String path, long revision) throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void openDir(String path, long revision) throws SVNException {
    }

    public void openFile(String path, long revision) throws SVNException {
    }

    public void abortEdit() throws SVNException {
    }
}

