/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNCommitMediator;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCommitter;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNCopyClient
extends SVNBasicClient {
    private ISVNCommitHandler myCommitHandler;
    private ISVNCommitParameters myCommitParameters;

    public SVNCopyClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNCopyClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        this.myCommitHandler = handler;
    }

    public ISVNCommitHandler getCommitHandler() {
        if (this.myCommitHandler == null) {
            this.myCommitHandler = new DefaultSVNCommitHandler();
        }
        return this.myCommitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters parameters) {
        this.myCommitParameters = parameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        if (this.myCommitParameters == null) {
            this.myCommitParameters = new DefaultSVNCommitParameters();
        }
        return this.myCommitParameters;
    }

    public SVNCommitInfo doCopy(SVNURL srcURL, SVNRevision srcRevision, SVNURL dstURL, boolean isMove, String commitMessage) throws SVNException {
        return this.doCopy(srcURL, srcRevision, dstURL, isMove, false, commitMessage);
    }

    public SVNCommitInfo doCopy(SVNURL srcURL, SVNRevision srcRevision, SVNURL dstURL, boolean isMove, boolean failWhenDstExists, String commitMessage) throws SVNException {
        SVNErrorMessage err;
        SVNNodeKind dstKind;
        SVNNodeKind srcKind;
        SVNRepository repository;
        SVNURL topURL = SVNURLUtil.getCommonURLAncestor(srcURL, dstURL);
        if (topURL == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source and dest appear not to be in the same repository (src: ''{0}''; dst: ''{1}'')", new Object[]{srcURL, dstURL});
            SVNErrorManager.error(err2);
        }
        boolean isResurrect = false;
        if (dstURL.equals(srcURL)) {
            topURL = srcURL.removePathTail();
            isResurrect = true;
        }
        if (!dstURL.equals((repository = this.createRepository(topURL, true)).getRepositoryRoot(true)) && srcURL.getPath().startsWith(dstURL.getPath() + "/")) {
            isResurrect = true;
            topURL = topURL.removePathTail();
            repository = this.createRepository(topURL, true);
        }
        String srcPath = srcURL.equals(topURL) ? "" : srcURL.getURIEncodedPath().substring(topURL.getURIEncodedPath().length() + 1);
        srcPath = SVNEncodingUtil.uriDecode(srcPath);
        String dstPath = dstURL.equals(topURL) ? "" : dstURL.getURIEncodedPath().substring(topURL.getURIEncodedPath().length() + 1);
        dstPath = SVNEncodingUtil.uriDecode(dstPath);
        if ("".equals(srcPath) && isMove) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move URL ''{0}'' into itself", srcURL);
            SVNErrorManager.error(err3);
        }
        long srcRevNumber = this.getRevisionNumber(srcRevision, repository, null);
        long latestRevision = repository.getLatestRevision();
        if (srcRevNumber < 0L) {
            srcRevNumber = latestRevision;
        }
        if ((srcKind = repository.checkPath(srcPath, srcRevNumber)) == SVNNodeKind.NONE) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' does not exist in revision {1}", new Object[]{srcURL, new Long(srcRevNumber)});
            SVNErrorManager.error(err4);
        }
        if ((dstKind = repository.checkPath(dstPath, latestRevision)) == SVNNodeKind.DIR) {
            if (failWhenDstExists) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", dstPath);
                SVNErrorManager.error(err);
            }
            if (repository.checkPath(dstPath = SVNPathUtil.append(dstPath, SVNPathUtil.tail(srcURL.getPath())), latestRevision) != SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", dstPath);
                SVNErrorManager.error(err);
            }
        } else if (dstKind == SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", dstPath);
            SVNErrorManager.error(err);
        }
        ArrayList<SVNCommitItem> commitItems = new ArrayList<SVNCommitItem>(2);
        commitItems.add(new SVNCommitItem(null, dstURL, srcURL, srcKind, SVNRevision.UNDEFINED, SVNRevision.create(srcRevNumber), true, false, false, false, true, false));
        if (isMove) {
            commitItems.add(new SVNCommitItem(null, srcURL, null, srcKind, SVNRevision.create(srcRevNumber), SVNRevision.UNDEFINED, false, true, false, false, false, false));
        }
        if ((commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, commitItems.toArray(new SVNCommitItem[commitItems.size()]))) == null) {
            return SVNCommitInfo.NULL;
        }
        commitMessage = SVNCommitClient.validateCommitMessage(commitMessage);
        ISVNEditor commitEditor = repository.getCommitEditor(commitMessage, null, false, null);
        CopyCommitPathHandler committer = new CopyCommitPathHandler(srcPath, srcRevNumber, srcKind, dstPath, isMove, isResurrect);
        List<String> paths = isMove ? Arrays.asList(srcPath, dstPath) : Collections.singletonList(dstPath);
        SVNCommitInfo result = null;
        try {
            SVNCommitUtil.driveCommitEditor(committer, paths, commitEditor, -1L);
            result = commitEditor.closeEdit();
        }
        catch (SVNException e) {
            try {
                commitEditor.abortEdit();
            }
            catch (SVNException inner) {
                // empty catch block
            }
            SVNErrorMessage nestedErr = e.getErrorMessage();
            SVNErrorMessage err5 = SVNErrorMessage.create(nestedErr.getErrorCode(), "Commit failed (details follow):");
            SVNErrorManager.error(err5, e);
        }
        if (result != null && result.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createCommitCompletedEvent(null, result.getNewRevision()), -1.0);
        }
        return result != null ? result : SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doCopy(File srcPath, SVNRevision srcRevision, SVNURL dstURL, String commitMessage) throws SVNException {
        return this.doCopy(srcPath, srcRevision, dstURL, false, commitMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo doCopy(File srcPath, SVNRevision srcRevision, SVNURL dstURL, boolean failWhenDstExists, String commitMessage) throws SVNException {
        ISVNEditor commitEditor;
        SVNCommitInfo info;
        SVNWCAccess wcAccess;
        block25: {
            Iterator files2;
            SVNEntry entry;
            TreeMap commitables;
            Collection tmpFiles;
            SVNAdminArea dirArea;
            SVNCommitItem[] items;
            SVNRepository repository;
            block23: {
                SVNCommitInfo sVNCommitInfo;
                block24: {
                    SVNErrorMessage err;
                    srcPath = new File(SVNPathUtil.validateFilePath(srcPath.getAbsolutePath()));
                    if (srcRevision.isValid() && srcRevision != SVNRevision.WORKING) {
                        SVNErrorMessage err2;
                        SVNWCAccess wcAccess2 = this.createWCAccess();
                        wcAccess2.probeOpen(srcPath, false, 0);
                        SVNEntry srcEntry = wcAccess2.getEntry(srcPath, false);
                        wcAccess2.close();
                        if (srcEntry == null) {
                            err2 = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", srcPath);
                            SVNErrorManager.error(err2);
                        }
                        if (srcEntry.getURL() == null) {
                            err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' does not seem to have a URL associated with it", srcPath);
                            SVNErrorManager.error(err2);
                        }
                        return this.doCopy(srcEntry.getSVNURL(), srcRevision, dstURL, false, failWhenDstExists, commitMessage);
                    }
                    wcAccess = this.createWCAccess();
                    SVNAdminArea adminArea = wcAccess.probeOpen(srcPath, false, -1);
                    wcAccess.setAnchor(adminArea.getRoot());
                    SVNURL dstAnchorURL = dstURL.removePathTail();
                    String dstTarget = SVNPathUtil.tail(dstURL.toString());
                    dstTarget = SVNEncodingUtil.uriDecode(dstTarget);
                    repository = this.createRepository(dstAnchorURL, true);
                    SVNNodeKind dstKind = repository.checkPath(dstTarget, -1L);
                    if (dstKind == SVNNodeKind.DIR) {
                        if (failWhenDstExists) {
                            err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", dstURL);
                            SVNErrorManager.error(err);
                        }
                        dstURL = dstURL.appendPath(srcPath.getName(), false);
                    } else if (dstKind == SVNNodeKind.FILE) {
                        err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "File ''{0}'' already exists", dstURL);
                        SVNErrorManager.error(err);
                    }
                    items = new SVNCommitItem[]{new SVNCommitItem(null, dstURL, null, SVNNodeKind.NONE, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, true, false, false, false, true, false)};
                    items[0].setWCAccess(adminArea.getWCAccess());
                    commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, items);
                    if (commitMessage == null) {
                        return SVNCommitInfo.NULL;
                    }
                    dirArea = null;
                    dirArea = SVNFileType.getType(srcPath) == SVNFileType.DIRECTORY ? wcAccess.retrieve(srcPath) : adminArea;
                    tmpFiles = null;
                    info = null;
                    commitEditor = null;
                    commitables = new TreeMap();
                    entry = wcAccess.getEntry(srcPath, false);
                    if (entry != null) break block23;
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", srcPath);
                    SVNErrorManager.error(err3);
                    sVNCommitInfo = SVNCommitInfo.NULL;
                    Object var22_26 = null;
                    if (tmpFiles == null) break block24;
                    Iterator files2 = tmpFiles.iterator();
                    while (files2.hasNext()) {
                        File file = (File)files2.next();
                        file.delete();
                    }
                }
                if (commitEditor != null && info == null) {
                    commitEditor.abortEdit();
                }
                if (wcAccess != null) {
                    wcAccess.close();
                }
                return sVNCommitInfo;
            }
            try {
                SVNCommitUtil.harvestCommitables(commitables, dirArea, srcPath, null, entry, dstURL.toString(), entry.getURL(), true, false, false, null, true, false, this.getCommitParameters());
                items = commitables.values().toArray(new SVNCommitItem[commitables.values().size()]);
                for (int i = 0; i < items.length; ++i) {
                    items[i].setWCAccess(wcAccess);
                }
                commitables = new TreeMap();
                dstURL = SVNURL.parseURIEncoded(SVNCommitUtil.translateCommitables(items, commitables));
                repository = this.createRepository(dstURL, true);
                SVNCommitMediator mediator = new SVNCommitMediator(commitables);
                tmpFiles = mediator.getTmpFiles();
                commitMessage = SVNCommitClient.validateCommitMessage(commitMessage);
                commitEditor = repository.getCommitEditor(commitMessage, null, false, mediator);
                info = SVNCommitter.commit(tmpFiles, commitables, repository.getRepositoryRoot(true).getPath(), commitEditor);
                commitEditor = null;
                Object var22_27 = null;
                if (tmpFiles == null) break block25;
                files2 = tmpFiles.iterator();
            }
            catch (Throwable throwable) {
                Object var22_28 = null;
                if (tmpFiles != null) {
                    Iterator files2 = tmpFiles.iterator();
                    while (files2.hasNext()) {
                        File file = (File)files2.next();
                        file.delete();
                    }
                }
                if (commitEditor != null && info == null) {
                    commitEditor.abortEdit();
                }
                if (wcAccess != null) {
                    wcAccess.close();
                }
                throw throwable;
            }
            while (files2.hasNext()) {
                File file = (File)files2.next();
                file.delete();
            }
        }
        if (commitEditor != null && info == null) {
            commitEditor.abortEdit();
        }
        if (wcAccess != null) {
            wcAccess.close();
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createCommitCompletedEvent(null, info.getNewRevision()), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doCopy(SVNURL srcURL, SVNRevision srcRevision, File dstPath) throws SVNException {
        long revision;
        block23: {
            SVNErrorMessage err;
            SVNFileType dstFileType;
            long srcRevisionNumber;
            SVNNodeKind srcKind;
            SVNRepository repository = this.createRepository(srcURL, true);
            if (!srcRevision.isValid()) {
                srcRevision = SVNRevision.HEAD;
            }
            if ((srcKind = repository.checkPath("", srcRevisionNumber = this.getRevisionNumber(srcRevision, repository, null))) == SVNNodeKind.NONE) {
                SVNErrorMessage err2;
                if (SVNRevision.isValidRevisionNumber(srcRevisionNumber)) {
                    err2 = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' not found in revision {1}", new Object[]{srcURL, new Long(srcRevisionNumber)});
                    SVNErrorManager.error(err2);
                } else {
                    err2 = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' not found in head revision", srcURL);
                    SVNErrorManager.error(err2);
                }
            }
            if ((dstFileType = SVNFileType.getType(dstPath)) == SVNFileType.DIRECTORY) {
                dstPath = new File(dstPath, SVNPathUtil.tail(srcURL.getPath()));
            } else if (dstFileType != SVNFileType.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "File ''{0}'' already exists", dstPath);
                SVNErrorManager.error(err);
            }
            dstFileType = SVNFileType.getType(dstPath);
            if (dstFileType != SVNFileType.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' is in the way", dstPath);
                SVNErrorManager.error(err);
            }
            SVNWCAccess dstAccess = this.createWCAccess();
            revision = -1L;
            try {
                SVNAdminArea adminArea = dstAccess.probeOpen(dstPath, true, 0);
                SVNEntry dstEntry = dstAccess.getEntry(dstPath, false);
                if (dstEntry != null && !dstEntry.isDirectory() && !dstEntry.isScheduledForDeletion()) {
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Entry for ''{0}'' exists (though the working copy file is missing)", dstPath);
                    SVNErrorManager.error(err3);
                }
                String srcUUID = null;
                String dstUUID = null;
                try {
                    srcUUID = repository.getRepositoryUUID(true);
                    dstUUID = this.getUUIDFromPath(dstAccess, dstPath.getParentFile());
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NO_REPOS_UUID) {
                        dstUUID = null;
                        srcUUID = null;
                    }
                    throw e;
                }
                boolean sameRepositories = dstUUID == null || srcUUID == null ? false : srcUUID.equals(dstUUID);
                if (srcKind == SVNNodeKind.DIR) {
                    SVNUpdateClient updateClient = new SVNUpdateClient(this.getRepositoryPool(), this.getOptions());
                    updateClient.setEventHandler(this.getEventDispatcher());
                    revision = updateClient.doCheckout(srcURL, dstPath, srcRevision, srcRevision, true);
                    if (srcRevision == SVNRevision.HEAD && sameRepositories) {
                        SVNAdminArea dstArea = dstAccess.open(dstPath, true, -1);
                        SVNEntry dstRootEntry = dstArea.getEntry(dstArea.getThisDirName(), false);
                        revision = dstRootEntry.getRevision();
                    }
                    if (sameRepositories) {
                        SVNWCManager.add(dstPath, adminArea, srcURL, revision);
                    } else {
                        SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source URL ''{0}'' is from foreign repository; leaving it as a disjoint WC", srcURL);
                        SVNErrorManager.error(err4);
                    }
                    break block23;
                }
                if (srcKind != SVNNodeKind.FILE) break block23;
                HashMap properties = new HashMap();
                File tmpFile = null;
                File baseTmpFile = adminArea.getBaseFile(dstPath.getName(), true);
                tmpFile = SVNFileUtil.createUniqueFile(baseTmpFile.getParentFile(), ".copy", ".tmp");
                OutputStream os = null;
                long realRevision = -1L;
                try {
                    os = SVNFileUtil.openFileForWriting(tmpFile);
                    realRevision = repository.getFile("", srcRevisionNumber, properties, new SVNCancellableOutputStream(os, this));
                }
                finally {
                    SVNFileUtil.closeFile(os);
                }
                if (!SVNRevision.isValidRevisionNumber(srcRevisionNumber)) {
                    srcRevisionNumber = realRevision;
                }
                SVNWCManager.addRepositoryFile(adminArea, dstPath.getName(), null, tmpFile, null, properties, sameRepositories ? srcURL.toString() : null, sameRepositories ? srcRevisionNumber : -1L);
                this.dispatchEvent(SVNEventFactory.createAddedEvent(null, adminArea, dstAccess.getEntry(dstPath, false)));
                revision = srcRevisionNumber;
                this.sleepForTimeStamp();
            }
            finally {
                dstAccess.close();
            }
        }
        return revision;
    }

    private String getUUIDFromPath(SVNWCAccess wcAccess, File path) throws SVNException {
        SVNEntry entry = wcAccess.getEntry(path, true);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Can''t find entry for ''{0}''", path);
            SVNErrorManager.error(err);
        }
        String uuid = null;
        if (entry.getUUID() != null) {
            uuid = entry.getUUID();
        } else if (entry.getURL() != null) {
            SVNRepository repos = this.createRepository(entry.getSVNURL(), false);
            uuid = repos.getRepositoryUUID(true);
        } else {
            if (wcAccess.isWCRoot(path)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path);
                SVNErrorManager.error(err);
            }
            uuid = this.getUUIDFromPath(wcAccess, path.getParentFile());
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopy(File srcPath, SVNRevision srcRevision, File dstPath, boolean force, boolean isMove) throws SVNException {
        SVNErrorMessage err;
        SVNFileType dstType;
        SVNFileType srcType;
        SVNErrorMessage err2;
        srcPath = new File(SVNPathUtil.validateFilePath(srcPath.getAbsolutePath())).getAbsoluteFile();
        dstPath = new File(SVNPathUtil.validateFilePath(dstPath.getAbsolutePath())).getAbsoluteFile();
        if (srcRevision.isValid() && srcRevision != SVNRevision.WORKING && !isMove) {
            SVNWCAccess wcAccess = this.createWCAccess();
            SVNURL srcURL = null;
            try {
                SVNErrorMessage err3;
                wcAccess.probeOpen(srcPath, false, 0);
                SVNEntry srcEntry = wcAccess.getEntry(srcPath, false);
                if (srcEntry == null) {
                    err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", srcPath);
                    SVNErrorManager.error(err3);
                }
                if (srcEntry.getURL() == null) {
                    err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", srcPath);
                    SVNErrorManager.error(err3);
                }
                srcURL = srcEntry.getSVNURL();
            }
            finally {
                wcAccess.close();
            }
            this.doCopy(srcURL, srcRevision, dstPath);
            return;
        }
        if (SVNPathUtil.isChildOf(srcPath, dstPath) || srcPath.equals(dstPath)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy ''{0}'' into its own child ''{1}''", new Object[]{srcPath, dstPath});
            SVNErrorManager.error(err2);
        }
        if (isMove && srcPath.equals(dstPath)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move ''{0}'' into itself", srcPath);
            SVNErrorManager.error(err2);
        }
        if ((srcType = SVNFileType.getType(srcPath)) == SVNFileType.NONE) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", srcPath);
            SVNErrorManager.error(err4);
        }
        if ((dstType = SVNFileType.getType(dstPath)) == SVNFileType.DIRECTORY) {
            dstType = SVNFileType.getType(dstPath = new File(dstPath, srcPath.getName()));
            if (dstType != SVNFileType.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists and is in the way", dstPath);
                SVNErrorManager.error(err);
            }
        } else if (dstType != SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "File ''{0}'' already exists", dstPath);
            SVNErrorManager.error(err);
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        SVNAdminArea adminArea = null;
        File srcParent = srcPath.getParentFile();
        File dstParent = dstPath.getParentFile();
        try {
            SVNAdminArea srcParentArea = null;
            if (isMove) {
                srcParentArea = wcAccess.open(srcParent, true, srcType == SVNFileType.DIRECTORY ? -1 : 0);
                adminArea = srcParent.equals(dstParent) ? srcParentArea : (srcType == SVNFileType.DIRECTORY && SVNPathUtil.isChildOf(srcParent, dstParent) ? wcAccess.retrieve(dstParent) : wcAccess.open(dstParent, true, 0));
                if (!force) {
                    try {
                        SVNWCManager.canDelete(srcPath, false, this.getOptions());
                    }
                    catch (SVNException svne) {
                        SVNErrorMessage err5 = svne.getErrorMessage().wrap("Move will not be attempted unless forced");
                        SVNErrorManager.error(err5, svne);
                    }
                }
            } else {
                adminArea = wcAccess.open(dstParent, true, 0);
            }
            SVNWCAccess copyAccess = this.createWCAccess();
            try {
                SVNErrorMessage err6;
                SVNEntry srcEntry;
                SVNAdminArea srcArea = copyAccess.probeOpen(srcPath, false, -1);
                SVNEntry dstEntry = adminArea.getEntry(adminArea.getThisDirName(), false);
                if (dstEntry == null) {
                    SVNErrorMessage err7 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", adminArea.getRoot());
                    SVNErrorManager.error(err7);
                }
                if ((srcEntry = copyAccess.getEntry(srcPath, false)) == null) {
                    err6 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", srcPath);
                    SVNErrorManager.error(err6);
                }
                if (srcEntry.getRepositoryRoot() != null && dstEntry.getRepositoryRoot() != null && !srcEntry.getRepositoryRoot().equals(dstEntry.getRepositoryRoot())) {
                    err6 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", new Object[]{adminArea.getRoot(), srcEntry.getRepositoryRoot(), dstEntry.getRepositoryRoot()});
                    SVNErrorManager.error(err6);
                }
                if (dstEntry.isScheduledForDeletion()) {
                    err6 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'' as it is scheduled for deletion", adminArea.getRoot());
                    SVNErrorManager.error(err6);
                }
                if (srcType == SVNFileType.FILE) {
                    this.copyFile(adminArea, srcArea, srcPath, dstPath.getName());
                } else if (srcType == SVNFileType.DIRECTORY) {
                    this.copyDir(adminArea, srcArea, srcPath, dstPath.getName());
                }
            }
            finally {
                copyAccess.close();
            }
            if (isMove) {
                SVNWCManager.delete(srcParentArea.getWCAccess(), srcParentArea, srcPath, true);
            }
        }
        finally {
            wcAccess.close();
        }
    }

    private void copyFile(SVNAdminArea dstParent, SVNAdminArea srcArea, File srcPath, String dstName) throws SVNException {
        SVNErrorMessage err;
        SVNEntry srcEntry;
        SVNEntry dstEntry;
        SVNWCAccess wcAccess = dstParent.getWCAccess();
        File dstPath = dstParent.getFile(dstName);
        if (SVNFileType.getType(dstPath) != SVNFileType.NONE) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' already exists and is in the way", dstPath);
            SVNErrorManager.error(err2);
        }
        if ((dstEntry = wcAccess.getEntry(dstPath, false)) != null && dstEntry.isFile() && !dstEntry.isScheduledForDeletion()) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "There is already a versioned item ''{0}''", dstPath);
            SVNErrorManager.error(err3);
        }
        if ((srcEntry = srcArea.getWCAccess().getEntry(srcPath, false)) == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "Cannot copy or move ''{0}'': it''s not under version control", srcPath);
            SVNErrorManager.error(err);
        }
        if (srcEntry.isScheduledForAddition() || srcEntry.getURL() == null || srcEntry.isCopied()) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy or move ''{0}'': it''s not in repository yet; try committing first", srcPath);
            SVNErrorManager.error(err);
        }
        File textBase = srcArea.getBaseFile(srcPath.getName(), false);
        File tmpTextBase = dstParent.getBaseFile(dstName, true);
        String copyFromURL = srcEntry.getURL();
        long copyFromRevision = srcEntry.getRevision();
        Map baseProperties = srcArea.getBaseProperties(srcEntry.getName()).asMap();
        Map properties = srcArea.getProperties(srcEntry.getName()).asMap();
        SVNFileUtil.copyFile(textBase, tmpTextBase, false);
        File tmpFile = SVNFileUtil.createUniqueFile(dstParent.getRoot(), ".copy", ".tmp");
        SVNFileUtil.copy(srcArea.getFile(srcEntry.getName()), tmpFile, false, false);
        SVNWCManager.addRepositoryFile(dstParent, dstName, tmpFile, tmpTextBase, baseProperties, properties, copyFromURL, copyFromRevision);
        SVNEvent event = SVNEventFactory.createAddedEvent(dstParent, dstName, SVNNodeKind.FILE, null);
        dstParent.getWCAccess().handleEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDir(SVNAdminArea dstParent, SVNAdminArea srcArea, File srcPath, String dstName) throws SVNException {
        SVNErrorMessage err;
        SVNEntry srcEntry = srcArea.getWCAccess().getEntry(srcPath, false);
        if (srcEntry == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "'{0}'' is not under version control", srcPath);
            SVNErrorManager.error(err);
        }
        if (srcEntry.isScheduledForAddition() || srcEntry.getURL() == null || srcEntry.isCopied()) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy or move ''{0}'': it''s not in repository yet; try committing first", srcPath);
            SVNErrorManager.error(err);
        }
        File dstPath = dstParent.getFile(dstName);
        SVNFileUtil.copyDirectory(srcPath, dstPath, true, srcArea.getWCAccess());
        SVNWCClient wcClient = new SVNWCClient((ISVNAuthenticationManager)null, (ISVNOptions)null);
        wcClient.doCleanup(dstPath);
        SVNWCAccess tmpAccess = SVNWCAccess.newInstance(null);
        try {
            SVNAdminArea tmpDir = tmpAccess.open(dstPath, true, -1);
            SVNCopyClient.postCopyCleanup(tmpDir);
        }
        finally {
            tmpAccess.close();
        }
        SVNWCManager.add(dstPath, dstParent, srcEntry.getSVNURL(), srcEntry.getRevision());
    }

    static void postCopyCleanup(SVNAdminArea dir) throws SVNException {
        SVNPropertiesManager.deleteWCProperties(dir, null, false);
        SVNFileUtil.setHidden(dir.getAdminDirectory(), true);
        Iterator entries = dir.entries(true);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            boolean deleted = entry.isDeleted();
            SVNNodeKind kind = entry.getKind();
            if (entry.isDeleted()) {
                entry.setSchedule("delete");
                entry.setDeleted(false);
                if (entry.isDirectory()) {
                    entry.setKind(SVNNodeKind.FILE);
                }
            }
            if (entry.getLockToken() != null) {
                entry.setLockToken(null);
                entry.setLockOwner(null);
                entry.setLockCreationDate(null);
            }
            if (deleted || kind != SVNNodeKind.DIR || dir.getThisDirName().equals(entry.getName())) continue;
            SVNAdminArea childDir = dir.getWCAccess().retrieve(dir.getFile(entry.getName()));
            SVNCopyClient.postCopyCleanup(childDir);
        }
        dir.saveEntries(false);
    }

    private static class CopyCommitPathHandler
    implements ISVNCommitPathHandler {
        private String mySrcPath;
        private String myDstPath;
        private long mySrcRev;
        private boolean myIsMove;
        private boolean myIsResurrect;
        private SVNNodeKind mySrcKind;

        public CopyCommitPathHandler(String srcPath, long srcRev, SVNNodeKind srcKind, String dstPath, boolean isMove, boolean isRessurect) {
            this.mySrcPath = srcPath;
            this.myDstPath = dstPath;
            this.mySrcRev = srcRev;
            this.myIsMove = isMove;
            this.mySrcKind = srcKind;
            this.myIsResurrect = isRessurect;
        }

        public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
            boolean doAdd = false;
            boolean doDelete = false;
            if (this.myIsResurrect) {
                if (!this.myIsMove) {
                    doAdd = true;
                }
            } else if (this.myIsMove) {
                if (commitPath.equals(this.mySrcPath)) {
                    doDelete = true;
                } else {
                    doAdd = true;
                }
            } else {
                doAdd = true;
            }
            if (doDelete) {
                commitEditor.deleteEntry(this.mySrcPath, -1L);
            }
            boolean closeDir = false;
            if (doAdd) {
                if (this.mySrcKind == SVNNodeKind.DIR) {
                    commitEditor.addDir(this.myDstPath, this.mySrcPath, this.mySrcRev);
                    closeDir = true;
                } else {
                    commitEditor.addFile(this.myDstPath, this.mySrcPath, this.mySrcRev);
                    commitEditor.closeFile(this.myDstPath, null);
                }
            }
            return closeDir;
        }
    }
}

