/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.togglz.console.RequestEvent;
import org.togglz.console.RequestHandler;
import org.togglz.console.shade.jmte.Engine;
import org.togglz.core.Togglz;

public abstract class RequestHandlerBase
implements RequestHandler {
    protected void writeResponse(RequestEvent event, String body) throws IOException {
        HttpServletResponse response = event.getResponse();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("content", body);
        model.put("serverInfo", event.getContext().getServerInfo());
        model.put("togglzTitle", Togglz.getNameWithVersion());
        if (event.getContext().getServletContextName() != null) {
            model.put("displayName", event.getContext().getServletContextName());
        }
        String template = this.getResourceAsString("template.html");
        String result = new Engine().transform(template, model);
        response.setContentType("text/html");
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(result.getBytes(StandardCharsets.UTF_8));
        response.flushBuffer();
    }

    protected String getResourceAsString(String name) throws IOException {
        InputStream stream = this.loadResource(name);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.copy(stream, bos);
        return new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }

    protected InputStream loadResource(String name) {
        String templateName = RequestHandler.class.getPackage().getName().replace('.', '/') + "/" + name;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(templateName);
    }

    protected void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[1024];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }
}

