/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.metadata.property;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.metadata.FeatureGroup;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.metadata.SimpleFeatureGroup;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.Strings;

public class PropertyFeatureMetaData
implements FeatureMetaData {
    private String label;
    private final FeatureState defaultFeatureState;
    private final Set<FeatureGroup> groups = new HashSet<FeatureGroup>();

    public PropertyFeatureMetaData(Feature feature, String specification) {
        boolean enabledByDefault = false;
        if (Strings.isNotBlank(specification)) {
            String[] parts = specification.split(";");
            if (parts.length >= 1) {
                this.label = parts[0];
            }
            if (parts.length >= 2) {
                enabledByDefault = Boolean.parseBoolean(parts[1]);
            }
            if (parts.length >= 3) {
                this.groups.addAll(this.parseFeatureGroups(parts[2]));
            }
        }
        if (Strings.isBlank(this.label)) {
            this.label = feature.name();
        }
        this.defaultFeatureState = new FeatureState(feature, enabledByDefault);
    }

    private Set<FeatureGroup> parseFeatureGroups(String value) {
        HashSet<FeatureGroup> groups = new HashSet<FeatureGroup>();
        for (String label : value.split(",")) {
            if (!Strings.isNotBlank(label)) continue;
            groups.add(new SimpleFeatureGroup(label.trim()));
        }
        return groups;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public FeatureState getDefaultFeatureState() {
        return this.defaultFeatureState;
    }

    @Override
    public Set<FeatureGroup> getGroups() {
        return this.groups;
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }
}

