/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.spi.FeatureManagerProvider;
import org.togglz.core.util.ConcurrentReferenceHashMap;
import org.togglz.core.util.Weighted;

public class FeatureContext {
    private static final Log log = LogFactory.getLog(FeatureContext.class);
    private static final ConcurrentReferenceHashMap<ClassLoader, FeatureManager> cache = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);

    public static FeatureManager getFeatureManager() {
        FeatureManager manager = FeatureContext.getFeatureManagerOrNull();
        if (manager != null) {
            return manager;
        }
        throw new IllegalStateException("Could not find the FeatureManager. For web applications please verify that the TogglzFilter starts up correctly. In other deployment scenarios you will typically have to implement a FeatureManagerProvider as described in the 'Advanced Configuration' chapter of the documentation.");
    }

    public static FeatureManager getFeatureManagerOrNull() {
        FeatureManager previousFeatureManager;
        ClassLoader classLoader = FeatureContext.getContextClassLoader();
        FeatureManager featureManager = cache.get(classLoader);
        if (featureManager != null) {
            return featureManager;
        }
        featureManager = FeatureContext.findFeatureManagerInClassLoader(classLoader);
        if (featureManager != null && (previousFeatureManager = cache.putIfAbsent(classLoader, featureManager)) != null) {
            return previousFeatureManager;
        }
        return featureManager;
    }

    private static FeatureManager findFeatureManagerInClassLoader(ClassLoader classLoader) {
        if (log.isDebugEnabled()) {
            log.debug("No cached FeatureManager for class loader: " + classLoader);
        }
        Iterator<FeatureManagerProvider> providerIterator = ServiceLoader.load(FeatureManagerProvider.class).iterator();
        ArrayList<FeatureManagerProvider> providerList = new ArrayList<FeatureManagerProvider>();
        while (providerIterator.hasNext()) {
            providerList.add(providerIterator.next());
        }
        Collections.sort(providerList, new Weighted.WeightedComparator());
        if (log.isDebugEnabled()) {
            log.debug("Found " + providerList.size() + " FeatureManagerProvider implementations...");
        }
        FeatureManager featureManager = null;
        for (FeatureManagerProvider provider : providerList) {
            featureManager = provider.getFeatureManager();
            if (log.isDebugEnabled()) {
                if (featureManager != null) {
                    log.debug("Provider " + provider.getClass().getName() + " returned FeatureManager: " + featureManager.getName());
                } else {
                    log.debug("No FeatureManager provided by " + provider.getClass().getName());
                }
            }
            if (featureManager == null) continue;
            break;
        }
        return featureManager;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Unable to get the context class loader for the current thread!");
        }
        return classLoader;
    }

    public static void clearCache() {
        cache.clear();
    }
}

