/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.togglz.core.util.Weighted;

public class Services {
    private static final Weighted.WeightedComparator WEIGHTED_COMPARATOR = new Weighted.WeightedComparator();

    public static <E> Collection<E> get(Class<? extends E> service) {
        Iterator<E> implementations = ServiceLoader.load(service).iterator();
        ArrayList<E> result = new ArrayList<E>();
        while (implementations.hasNext()) {
            result.add(implementations.next());
        }
        return result;
    }

    public static <E extends Weighted> List<E> getSorted(Class<? extends E> service) {
        ArrayList<? extends E> result = new ArrayList<E>(Services.get(service));
        Collections.sort(result, WEIGHTED_COMPARATOR);
        return result;
    }
}

