/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Strings {
    private static final Set<String> falseValues = new HashSet<String>(4);
    private static final Set<String> trueValues = new HashSet<String>(4);

    public static String join(Iterable<?> col, String separator) {
        StringBuilder result = new StringBuilder();
        Iterator<?> it = col.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean equalsIgnoreCase(String s, String v) {
        return s != null && s.trim().equalsIgnoreCase(v);
    }

    public static List<String> splitAndTrim(String value, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        if (Strings.isNotBlank(value)) {
            String[] segements;
            for (String segment : segements = value.split(regex)) {
                if (!Strings.isNotBlank(segment)) continue;
                result.add(segment.trim());
            }
        }
        return result;
    }

    public static String trim(String s) {
        return s != null ? s.trim() : null;
    }

    public static String trimToNull(String s) {
        return Strings.isNotEmpty(s = Strings.trim(s)) ? s : null;
    }

    public static String joinClassNames(Iterable<?> iterable) {
        StringBuilder result = new StringBuilder();
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            result.append(it.next().getClass().getName());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static Boolean toBoolean(String s) {
        String value = Strings.trimToNull(s);
        if (value == null) {
            return null;
        }
        if (trueValues.contains(value = value.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (falseValues.contains(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value '" + s + "'");
    }

    static {
        falseValues.add("false");
        falseValues.add("off");
        falseValues.add("no");
        falseValues.add("0");
        trueValues.add("true");
        trueValues.add("on");
        trueValues.add("yes");
        trueValues.add("1");
    }
}

