/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.user.thread;

import org.togglz.core.user.FeatureUser;
import org.togglz.core.user.UserProvider;

public class ThreadLocalUserProvider
implements UserProvider {
    private static ThreadLocal<FeatureUser> threadLocal = new ThreadLocal();

    public static void bind(FeatureUser featureUser) {
        if (featureUser != null && threadLocal.get() != null) {
            throw new IllegalStateException("setFeatureUser() called for a thread that already has one associated with it. It's likely that the FeatureUser is not correctly removed from the thread before it is put back into the thread pool.");
        }
        threadLocal.set(featureUser);
    }

    public static void release() {
        threadLocal.set(null);
    }

    @Override
    public FeatureUser getCurrentUser() {
        return threadLocal.get();
    }
}

