/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.activation;

import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Strings;

public abstract class AbstractPropertyDrivenActivationStrategy
implements ActivationStrategy {
    private static final String DEFAULT_PROPERTY_PREFIX = "togglz.";
    private static final String DEFAULT_STATE_VALUE = "true";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_PROPERTY_VALUE = "value";

    protected String getPropertyName(FeatureState featureState, String parameterName) {
        String propertyName = featureState.getParameter(parameterName);
        if (Strings.isNotBlank(propertyName)) {
            return propertyName;
        }
        return DEFAULT_PROPERTY_PREFIX + featureState.getFeature().name();
    }

    protected abstract String getPropertyValue(FeatureState var1, FeatureUser var2, String var3);

    @Override
    public final boolean isActive(FeatureState featureState, FeatureUser user) {
        String propertyName = this.getPropertyName(featureState, this.getPropertyNameParam());
        String propertyValue = this.getPropertyValue(featureState, user, propertyName);
        return this.isActive(featureState, user, propertyName, propertyValue);
    }

    protected String getPropertyNameParam() {
        return PARAM_NAME;
    }

    protected boolean isActive(FeatureState featureState, FeatureUser user, String propertyName, String propertyValue) {
        String expectedValue = featureState.getParameter(PARAM_PROPERTY_VALUE);
        if (expectedValue == null) {
            expectedValue = DEFAULT_STATE_VALUE;
        }
        return Strings.isNotBlank(propertyValue) && expectedValue.equalsIgnoreCase(propertyValue);
    }

    @Override
    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create(PARAM_NAME).optional().label("Property Name").description("The name of the property to be used to determine whether the feature is enabled."), ParameterBuilder.create(PARAM_PROPERTY_VALUE).optional().label("Property Value").description("Enable the feature when this value matches the property value")};
    }
}

