/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.repository.property.PropertySource;
import org.togglz.core.util.IOUtils;

class ReloadablePropertiesFile
implements PropertySource {
    private static final Log log = LogFactory.getLog(ReloadablePropertiesFile.class);
    private final File file;
    private final int minCheckInterval;
    private Properties values = new Properties();
    private long lastRead = 0L;
    private long lastCheck = 0L;

    public ReloadablePropertiesFile(File file) {
        this(file, 1000);
    }

    public ReloadablePropertiesFile(File file, int minCheckInterval) {
        this.file = file;
        this.minCheckInterval = minCheckInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void reloadIfUpdated() {
        long now;
        if (!this.file.exists()) {
            try {
                if (this.file.createNewFile()) {
                    log.debug("Created non-existent file.");
                }
            }
            catch (IOException e) {
                log.error("Error creating missing file " + this.file.getName(), e);
            }
        }
        if ((now = System.currentTimeMillis()) - this.lastCheck > (long)this.minCheckInterval) {
            this.lastCheck = now;
            if (this.file.lastModified() > this.lastRead) {
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(this.file);
                    Properties newValues = new Properties();
                    newValues.load(stream);
                    this.values = newValues;
                    this.lastRead = System.currentTimeMillis();
                    log.info("Reloaded file: " + this.file.getCanonicalPath());
                }
                catch (FileNotFoundException e) {
                    log.debug("File not found: " + this.file);
                    IOUtils.close(stream);
                }
                catch (IOException e2) {
                    log.error("Failed to read file", e2);
                    {
                        catch (Throwable throwable) {
                            IOUtils.close(stream);
                            throw throwable;
                        }
                    }
                    IOUtils.close(stream);
                }
                IOUtils.close(stream);
            }
        }
    }

    @Override
    public String getValue(String key, String defaultValue) {
        return this.values.getProperty(key, defaultValue);
    }

    @Override
    public Set<String> getKeysStartingWith(String prefix) {
        HashSet<String> result = new HashSet<String>();
        Enumeration<?> keys = this.values.propertyNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public PropertySource.Editor getEditor() {
        return new PropertyFileEditor(this.values);
    }

    private void write(Properties newValues) {
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            newValues.store(fos, null);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write new values", e);
        }
        this.lastRead = 0L;
        this.lastCheck = 0L;
    }

    private class PropertyFileEditor
    implements PropertySource.Editor {
        private final Properties newValues = new Properties();

        private PropertyFileEditor(Properties props) {
            this.newValues.putAll((Map<?, ?>)props);
        }

        @Override
        public void setValue(String key, String value) {
            if (value != null) {
                this.newValues.setProperty(key, value);
            } else {
                this.newValues.remove(key);
            }
        }

        @Override
        public void removeKeysStartingWith(String prefix) {
            this.newValues.entrySet().removeIf(entry -> entry.getKey().toString().startsWith(prefix));
        }

        @Override
        public void commit() {
            ReloadablePropertiesFile.this.write(this.newValues);
        }
    }
}

