/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository.property;

import java.util.List;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.repository.property.PropertySource;
import org.togglz.core.util.Strings;

public class PropertyBasedStateRepository
implements StateRepository {
    private final PropertySource propertySource;

    public PropertyBasedStateRepository(PropertySource propertySource) {
        this.propertySource = propertySource;
    }

    @Override
    public synchronized FeatureState getFeatureState(Feature feature) {
        this.propertySource.reloadIfUpdated();
        String enabledAsStr = this.propertySource.getValue(PropertyBasedStateRepository.getEnabledPropertyName(feature), null);
        if (enabledAsStr != null) {
            FeatureState state = new FeatureState(feature);
            state.setEnabled(PropertyBasedStateRepository.isTrue(enabledAsStr));
            String strategy = this.propertySource.getValue(PropertyBasedStateRepository.getStrategyPropertyName(feature), null);
            state.setStrategyId(strategy);
            String paramPrefix = PropertyBasedStateRepository.getParameterPropertyName(feature, "");
            for (String key : this.propertySource.getKeysStartingWith(paramPrefix)) {
                String id = key.substring(paramPrefix.length());
                String value = this.propertySource.getValue(key, null);
                state.setParameter(id, value);
            }
            List<String> additionalUsers = PropertyBasedStateRepository.toList(this.propertySource.getValue(PropertyBasedStateRepository.getUsersPropertyName(feature), null));
            if (!additionalUsers.isEmpty()) {
                List<String> currentUsers = PropertyBasedStateRepository.toList(state.getParameter("users"));
                currentUsers.addAll(additionalUsers);
                state.setParameter("users", Strings.join(currentUsers, ","));
                if (state.getStrategyId() == null) {
                    state.setStrategyId("username");
                }
            }
            return state;
        }
        return null;
    }

    @Override
    public synchronized void setFeatureState(FeatureState featureState) {
        this.propertySource.reloadIfUpdated();
        Feature feature = featureState.getFeature();
        PropertySource.Editor editor = this.propertySource.getEditor();
        String enabledKey = PropertyBasedStateRepository.getEnabledPropertyName(feature);
        String enabledValue = featureState.isEnabled() ? "true" : "false";
        editor.setValue(enabledKey, enabledValue);
        editor.setValue(PropertyBasedStateRepository.getStrategyPropertyName(feature), featureState.getStrategyId());
        String paramPrefix = PropertyBasedStateRepository.getParameterPropertyName(feature, "");
        editor.removeKeysStartingWith(paramPrefix);
        for (String id : featureState.getParameterNames()) {
            String key = PropertyBasedStateRepository.getParameterPropertyName(feature, id);
            editor.setValue(key, featureState.getParameter(id));
        }
        editor.setValue(PropertyBasedStateRepository.getUsersPropertyName(feature), null);
        editor.commit();
    }

    private static String getEnabledPropertyName(Feature feature) {
        return feature.name();
    }

    private static String getStrategyPropertyName(Feature feature) {
        return feature.name() + ".strategy";
    }

    private static String getParameterPropertyName(Feature feature, String parameter) {
        return feature.name() + ".param." + parameter;
    }

    private static String getUsersPropertyName(Feature feature) {
        return feature.name() + ".users";
    }

    private static boolean isTrue(String s) {
        return s != null && ("true".equalsIgnoreCase(s.trim()) || "yes".equalsIgnoreCase(s.trim()) || "enabled".equalsIgnoreCase(s.trim()) || "enable".equalsIgnoreCase(s.trim()));
    }

    private static List<String> toList(String input) {
        return Strings.splitAndTrim(input, ",");
    }
}

