/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.activation;

import java.util.ArrayList;
import java.util.List;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Strings;

public abstract class AbstractTokenizedActivationStrategy
implements ActivationStrategy {
    @Override
    public final boolean isActive(FeatureState featureState, FeatureUser user) {
        List<Token> tokens = this.tokenize(featureState, this.getTokenParameterName(), this.getTokenParameterTransformer());
        return this.isActive(featureState, user, tokens);
    }

    protected abstract boolean isActive(FeatureState var1, FeatureUser var2, List<Token> var3);

    protected List<Token> tokenize(FeatureState featureState, String parameterName, TokenTransformer transformer) {
        List<String> values = Strings.splitAndTrim(featureState.getParameter(parameterName), "[\\s,]+");
        ArrayList<Token> tokens = new ArrayList<Token>(values.size());
        for (String value : values) {
            boolean negated;
            if (transformer != null) {
                value = transformer.transform(value);
            }
            if (negated = value.startsWith("!")) {
                value = value.substring(1);
            }
            tokens.add(new Token(value, negated));
        }
        return tokens;
    }

    public abstract String getTokenParameterName();

    public TokenTransformer getTokenParameterTransformer() {
        return null;
    }

    public static interface TokenTransformer {
        public String transform(String var1);
    }

    public static final class Token {
        private final boolean negated;
        private final String value;

        private Token(String value, boolean negated) {
            this.value = value;
            this.negated = negated;
        }

        public boolean isNegated() {
            return this.negated;
        }

        public String getValue() {
            return this.value;
        }
    }
}

