/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.manager;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.activation.ActivationStrategyProvider;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.metadata.EmptyFeatureMetaData;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.spi.FeatureProvider;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.user.UserProvider;
import org.togglz.core.util.Validate;

public class DefaultFeatureManager
implements FeatureManager {
    private final String name;
    private final StateRepository stateRepository;
    private final UserProvider userProvider;
    private final FeatureProvider featureProvider;
    private final ActivationStrategyProvider strategyProvider;

    DefaultFeatureManager(String name, FeatureProvider featureProvider, StateRepository stateRepository, UserProvider userProvider, ActivationStrategyProvider activationStrategyProvider) {
        this.name = name;
        this.featureProvider = featureProvider;
        this.stateRepository = stateRepository;
        this.userProvider = userProvider;
        this.strategyProvider = activationStrategyProvider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<Feature> getFeatures() {
        return Collections.unmodifiableSet(this.featureProvider.getFeatures());
    }

    @Override
    public FeatureMetaData getMetaData(Feature feature) {
        Validate.notNull(feature, "feature is required");
        FeatureMetaData metadata = this.featureProvider.getMetaData(feature);
        if (metadata != null) {
            return metadata;
        }
        return new EmptyFeatureMetaData(feature);
    }

    @Override
    public boolean isActive(Feature feature) {
        Validate.notNull(feature, "feature is required");
        FeatureState state = this.stateRepository.getFeatureState(feature);
        if (state == null) {
            state = this.getMetaData(feature).getDefaultFeatureState();
        }
        if (state.isEnabled()) {
            String strategyId = state.getStrategyId();
            if (strategyId == null || strategyId.isEmpty()) {
                return true;
            }
            FeatureUser user = this.userProvider.getCurrentUser();
            for (ActivationStrategy strategy : this.strategyProvider.getActivationStrategies()) {
                if (!strategy.getId().equalsIgnoreCase(strategyId)) continue;
                return strategy.isActive(state, user);
            }
        }
        return false;
    }

    @Override
    public FeatureState getFeatureState(Feature feature) {
        Validate.notNull(feature, "feature is required");
        FeatureState state = this.stateRepository.getFeatureState(feature);
        if (state == null) {
            state = this.getMetaData(feature).getDefaultFeatureState();
        }
        return state;
    }

    @Override
    public void setFeatureState(FeatureState state) {
        Validate.notNull(state, "state is required");
        this.stateRepository.setFeatureState(state);
    }

    @Override
    public List<ActivationStrategy> getActivationStrategies() {
        return this.strategyProvider.getActivationStrategies();
    }

    @Override
    public void enable(Feature feature) {
        this.stateRepository.setFeatureState(new FeatureState(feature, true));
    }

    @Override
    public void disable(Feature feature) {
        this.stateRepository.setFeatureState(new FeatureState(feature, false));
    }

    @Override
    public FeatureUser getCurrentFeatureUser() {
        return this.userProvider.getCurrentUser();
    }

    public String toString() {
        return "DefaultFeatureManager[" + this.getName() + "]";
    }
}

