/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.manager;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.metadata.enums.EnumFeatureMetaData;
import org.togglz.core.spi.FeatureProvider;

public class EnumBasedFeatureProvider
implements FeatureProvider {
    private Map<String, FeatureMetaData> metaDataCache = null;
    private Set<Feature> features = null;

    public EnumBasedFeatureProvider() {
    }

    public EnumBasedFeatureProvider(Class<? extends Feature> ... featureEnums) {
        if (featureEnums == null) {
            throw new IllegalArgumentException("The featureEnums argument must not be null");
        }
        for (Class<? extends Feature> featureEnum : featureEnums) {
            this.addFeatureEnum(featureEnum);
        }
    }

    public EnumBasedFeatureProvider addFeatureEnum(Class<? extends Feature> featureEnum) {
        if (featureEnum == null || !featureEnum.isEnum()) {
            throw new IllegalArgumentException("The featureEnum argument must be an enum");
        }
        this.addFeatures(Arrays.asList(featureEnum.getEnumConstants()));
        return this;
    }

    private void addFeatures(Collection<? extends Feature> newFeatures) {
        if (this.metaDataCache == null) {
            this.metaDataCache = new HashMap<String, FeatureMetaData>();
        }
        for (Feature feature : newFeatures) {
            if (this.metaDataCache.put(feature.name(), new EnumFeatureMetaData(feature)) != null) {
                throw new IllegalStateException("The feature " + feature + " has already been added");
            }
            if (this.features == null) {
                this.features = new LinkedHashSet<Feature>();
            }
            this.features.add(feature);
        }
    }

    @Override
    public Set<Feature> getFeatures() {
        if (this.features == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.features);
    }

    @Override
    public FeatureMetaData getMetaData(Feature feature) {
        if (this.metaDataCache == null) {
            throw new IllegalStateException("There are no features added in this provider instance.");
        }
        return this.metaDataCache.get(feature.name());
    }
}

