/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.actuate.autoconfigure;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.NamedFeature;

@ConfigurationProperties(prefix="togglz", ignoreUnknownFields=true)
@Validated
public class TogglzProperties {
    private boolean enabled = true;
    private Class<? extends Feature>[] featureEnums;
    private String featureManagerName;
    private Map<String, FeatureSpec> features = new LinkedHashMap<String, FeatureSpec>();
    private String featuresFile;
    private Integer featuresFileMinCheckInterval;
    private Cache cache = new Cache();
    @Valid
    private Console console = new Console();
    private Endpoint endpoint = new Endpoint();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Class<? extends Feature>[] getFeatureEnums() {
        return this.featureEnums;
    }

    public void setFeatureEnums(Class<? extends Feature>[] featureEnums) {
        this.featureEnums = featureEnums;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFeatureManagerName() {
        return this.featureManagerName;
    }

    public void setFeatureManagerName(String featureManagerName) {
        this.featureManagerName = featureManagerName;
    }

    public Map<String, FeatureSpec> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, FeatureSpec> features) {
        this.features = features;
    }

    public String getFeaturesFile() {
        return this.featuresFile;
    }

    public void setFeaturesFile(String featuresFile) {
        this.featuresFile = featuresFile;
    }

    public Integer getFeaturesFileMinCheckInterval() {
        return this.featuresFileMinCheckInterval;
    }

    public void setFeaturesFileMinCheckInterval(Integer featuresFileMinCheckInterval) {
        this.featuresFileMinCheckInterval = featuresFileMinCheckInterval;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Console getConsole() {
        return this.console;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Properties getFeatureProperties() {
        Properties properties = new Properties();
        for (String name : this.features.keySet()) {
            properties.setProperty(name, this.features.get(name).spec());
        }
        return properties;
    }

    public static class Endpoint {
        private String id = "togglz";
        private boolean enabled = true;
        private boolean sensitive = true;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isSensitive() {
            return this.sensitive;
        }

        public void setSensitive(boolean sensitive) {
            this.sensitive = sensitive;
        }
    }

    public static class Web {
        private boolean registerFeatureInterceptor = false;

        public boolean isRegisterFeatureInterceptor() {
            return this.registerFeatureInterceptor;
        }

        public void setRegisterFeatureInterceptor(boolean registerFeatureInterceptor) {
            this.registerFeatureInterceptor = registerFeatureInterceptor;
        }
    }

    public static class Console {
        private boolean enabled = true;
        @NotNull
        @Pattern(regexp="/[^?#]*", message="Path must start with /")
        private @NotNull @Pattern(regexp="/[^?#]*", message="Path must start with /") String path = "/togglz-console";
        private String featureAdminAuthority;
        private boolean secured = true;
        private boolean useManagementPort = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFeatureAdminAuthority() {
            return this.featureAdminAuthority;
        }

        public void setFeatureAdminAuthority(String featureAdminAuthority) {
            this.featureAdminAuthority = featureAdminAuthority;
        }

        public boolean isSecured() {
            return this.secured;
        }

        public void setSecured(boolean secured) {
            this.secured = secured;
        }

        public boolean isUseManagementPort() {
            return this.useManagementPort;
        }

        public void setUseManagementPort(boolean useManagementPort) {
            this.useManagementPort = useManagementPort;
        }
    }

    public static class Cache {
        private boolean enabled = false;
        private long timeToLive = 0L;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public long getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }
    }

    public static class FeatureSpec {
        private boolean enabled;
        private String label;
        private String strategy;
        private Set<String> groups = new LinkedHashSet<String>();
        private Map<String, String> param = new LinkedHashMap<String, String>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public Map<String, String> getParam() {
            return this.param;
        }

        public FeatureState state(String name) {
            FeatureState state = new FeatureState(this.feature(name), this.enabled);
            for (String key : this.param.keySet()) {
                state.setParameter(key, this.param.get(key));
            }
            if (StringUtils.hasText((String)this.strategy)) {
                state.setStrategyId(this.strategy);
            }
            return state;
        }

        public Feature feature(String name) {
            return new NamedFeature(name);
        }

        public String spec() {
            return (this.label == null ? "" : this.label) + ";" + this.enabled + (this.groups.isEmpty() ? "" : ";" + StringUtils.collectionToCommaDelimitedString(this.groups));
        }

        public String toString() {
            return "FeatureSpec [label=" + this.label + ", enabled=" + this.enabled + ", groups=" + this.groups + ", strategy=" + this.strategy + ", param=" + this.param + "]";
        }
    }
}

