/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.actuate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.Preconditions;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzFeature;

@Component
@Endpoint(id="togglz")
public class TogglzEndpoint {
    private static final String PARAMETER_VALUE_SEPARATOR = "=";
    private final FeatureManager featureManager;

    public TogglzEndpoint(FeatureManager featureManager) {
        Assert.notNull((Object)featureManager, (String)"FeatureManager must not be null");
        this.featureManager = featureManager;
    }

    @ReadOperation
    public List<TogglzFeature> getAllFeatures() {
        ArrayList<TogglzFeature> features = new ArrayList<TogglzFeature>();
        for (Feature feature : this.featureManager.getFeatures()) {
            FeatureState featureState = this.featureManager.getFeatureState(feature);
            features.add(new TogglzFeature(feature, featureState));
        }
        Collections.sort(features);
        return features;
    }

    @ReadOperation
    public TogglzFeature getFeature(@Selector String name) {
        return this.featureManager.getFeatures().stream().filter(it -> name.equals(it.name())).findFirst().map(it -> new TogglzFeature((Feature)it, this.featureManager.getFeatureState(it))).orElse(null);
    }

    @WriteOperation
    public TogglzFeature setFeatureState(@Selector String name, @Nullable Boolean enabled, @Nullable String strategy, @Nullable String parameters) {
        Feature feature = this.featureManager.getFeatures().stream().filter(f -> f.name().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find feature with name " + name));
        Map<String, String> parametersMap = parameters != null ? StringUtils.commaDelimitedListToSet((String)parameters).stream().map(this::toParameterKeyValue).collect(Collectors.toMap(parameterKeyValue -> parameterKeyValue[0], parameterKeyValue -> parameterKeyValue[1])) : Collections.emptyMap();
        FeatureState featureState = this.changeFeatureStatus(feature, enabled, strategy, parametersMap);
        return new TogglzFeature(feature, featureState);
    }

    private FeatureState changeFeatureStatus(Feature feature, Boolean enabled, String strategy, Map<String, String> parameters) {
        FeatureState featureState = this.featureManager.getFeatureState(feature);
        if (enabled != null) {
            featureState.setEnabled(enabled.booleanValue());
        }
        if (strategy != null) {
            featureState.setStrategyId(strategy);
        }
        parameters.forEach((arg_0, arg_1) -> ((FeatureState)featureState).setParameter(arg_0, arg_1));
        this.featureManager.setFeatureState(featureState);
        return featureState;
    }

    private String[] toParameterKeyValue(String parameterString) {
        String[] parameterKeyValue = StringUtils.trimAllWhitespace((String)parameterString).split(PARAMETER_VALUE_SEPARATOR);
        Preconditions.checkArgument((parameterKeyValue.length == 2 ? 1 : 0) != 0, (String)"Illegal parameter key/value format: %s", (Object[])new Object[]{parameterString});
        return parameterKeyValue;
    }
}

