/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.trimou.engine.convert.Converter;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class ObjectToDateConverter
implements Converter<Object, Date> {
    private final String pattern;

    public ObjectToDateConverter() {
        this(null);
    }

    public ObjectToDateConverter(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Date convert(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String && this.pattern != null) {
            try {
                return new SimpleDateFormat(this.pattern).parse((String)value);
            }
            catch (ParseException e) {
                throw new MustacheException(MustacheProblem.RENDER_GENERIC_ERROR, "Unable to parse the string value %s using pattern %s", value, this.pattern);
            }
        }
        return null;
    }
}

