/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.listener;

import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.trimou.engine.listener.AbstractMustacheListener;

public class AbstractStatsCollector
extends AbstractMustacheListener {
    public static final Predicate<String> IS_NOT_ONEOFF_LAMBA_TEMPLATE = new Predicate<String>(){

        public boolean apply(String input) {
            return !input.startsWith("oneoff_lambda_");
        }
    };
    private final TimeUnit timeUnit;
    private final Predicate<String> templatePredicate;

    public AbstractStatsCollector(Predicate<String> templatePredicate, TimeUnit timeUnit) {
        this.timeUnit = timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS;
        this.templatePredicate = templatePredicate != null ? templatePredicate : IS_NOT_ONEOFF_LAMBA_TEMPLATE;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public boolean isApplied(String mustacheName) {
        return this.templatePredicate.apply((Object)mustacheName);
    }

    protected long convert(long value) {
        return this.timeUnit.convert(value, TimeUnit.NANOSECONDS);
    }

    public static class Stats {
        private final long id;
        private final String name;
        private final long finished;
        private final long errors;
        private final long totalTime;
        private final long meanTime;
        private final long minTime;
        private final long maxTime;

        public Stats(long id, String name, long finished, long errors, long totalTime, long meanTime, long minTime, long maxTime) {
            this.id = id;
            this.name = name;
            this.finished = finished;
            this.errors = errors;
            this.totalTime = totalTime;
            this.meanTime = meanTime;
            this.minTime = minTime;
            this.maxTime = maxTime;
        }

        protected long getId() {
            return this.id;
        }

        protected String getName() {
            return this.name;
        }

        protected long getFinished() {
            return this.finished;
        }

        protected long getErrors() {
            return this.errors;
        }

        protected long getTotalTime() {
            return this.totalTime;
        }

        protected long getMeanTime() {
            return this.meanTime;
        }

        protected long getMinTime() {
            return this.minTime;
        }

        protected long getMaxTime() {
            return this.maxTime;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Stats other = (Stats)obj;
            return this.id == other.id;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Stats [id=");
            builder.append(this.id);
            builder.append(", name=");
            builder.append(this.name);
            builder.append(", finished=");
            builder.append(this.finished);
            builder.append(", errors=");
            builder.append(this.errors);
            builder.append(", totalTime=");
            builder.append(this.totalTime);
            builder.append(", meanTime=");
            builder.append(this.meanTime);
            builder.append(", minTime=");
            builder.append(this.minTime);
            builder.append(", maxTime=");
            builder.append(this.maxTime);
            builder.append("]");
            return builder.toString();
        }
    }
}

