/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.resolver.AbstractResolver;

public abstract class IndexResolver
extends AbstractResolver {
    private static final Logger logger = LoggerFactory.getLogger(IndexResolver.class);

    public IndexResolver(int priority) {
        super(priority);
    }

    protected boolean notAnIndex(String name) {
        return !this.isAnIndex(name);
    }

    protected boolean isAnIndex(String name) {
        return NumberUtils.isDigits((String)name);
    }

    protected Integer getIndexValue(String name, int maxSize) {
        return this.getIndexValue(name, null, maxSize);
    }

    protected Integer getIndexValue(String name, String key, int maxSize) {
        Integer index;
        try {
            index = Integer.valueOf(name);
        }
        catch (NumberFormatException e) {
            logger.warn("Index '{}' is not a valid integer value, key: '{}'", new Object[]{name, maxSize, key != null ? key : "n/a"});
            return null;
        }
        if (index < 0 || index >= maxSize) {
            logger.warn("Trying to access index {} but the list/array has only {} elements, key: '{}'", new Object[]{index, maxSize, key != null ? key : "n/a"});
            return null;
        }
        return index;
    }
}

