/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.util.List;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.IndexResolver;
import org.trimou.engine.resolver.MapResolver;
import org.trimou.engine.resolver.ResolutionContext;

public class ListIndexResolver
extends IndexResolver {
    public static final int LIST_RESOLVER_PRIORITY = Priorities.rightAfter(MapResolver.MAP_RESOLVER_PRIORITY);

    public ListIndexResolver() {
        this(LIST_RESOLVER_PRIORITY);
    }

    public ListIndexResolver(int priority) {
        super(priority);
    }

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null || this.notAnIndex(name) || !(contextObject instanceof List)) {
            return null;
        }
        List list = (List)contextObject;
        Integer index = this.getIndexValue(name, list.size());
        if (index != null) {
            return list.get(index);
        }
        return null;
    }
}

