/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;

abstract class AbstractSegment
implements Segment {
    private final Origin origin;
    private final String text;
    private final MustacheTagInfo info;

    public AbstractSegment(String text, Origin origin) {
        Checker.checkArgumentsNotNull(text, origin);
        this.text = text;
        this.origin = origin;
        this.info = new DefaultSegmentInfo();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public MustacheTagInfo getTagInfo() {
        return this.info;
    }

    @Override
    public String getLiteralBlock() {
        return this.getTagLiteral(this.getText());
    }

    public String toString() {
        return String.format("%s:%s %s", new Object[]{this.getType(), this.getSegmentName(), this.getOrigin()});
    }

    public Template getTemplate() {
        return this.origin.getTemplate();
    }

    protected MustacheEngine getEngine() {
        return this.getTemplate().getEngine();
    }

    protected Configuration getEngineConfiguration() {
        return this.getEngine().getConfiguration();
    }

    protected String getDefaultStartDelimiter() {
        return this.getEngineConfiguration().getStringPropertyValue(EngineConfigurationKey.START_DELIMITER);
    }

    protected String getDefaultEndDelimiter() {
        return this.getEngineConfiguration().getStringPropertyValue(EngineConfigurationKey.END_DELIMITER);
    }

    protected String getTagLiteral(String content) {
        return this.getDefaultStartDelimiter() + content + this.getDefaultEndDelimiter();
    }

    protected boolean isHandlebarsSupportEnabled() {
        return this.getEngineConfiguration().getBooleanPropertyValue(EngineConfigurationKey.HANDLEBARS_SUPPORT_ENABLED);
    }

    protected String getSegmentName() {
        return "";
    }

    protected void append(Appendable appendable, String text) {
        try {
            appendable.append(text);
        }
        catch (IOException e) {
            throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
        }
    }

    protected MustacheTagType getTagType() {
        return this.getType().getTagType();
    }

    protected List<MustacheTagInfo> getDirectChildTags() {
        return Collections.emptyList();
    }

    class DefaultSegmentInfo
    implements MustacheTagInfo {
        DefaultSegmentInfo() {
        }

        @Override
        public MustacheTagType getType() {
            return AbstractSegment.this.getTagType();
        }

        @Override
        public String getText() {
            return AbstractSegment.this.text;
        }

        @Override
        public int getLine() {
            return AbstractSegment.this.origin.getLine();
        }

        @Override
        public String getTemplateName() {
            return AbstractSegment.this.origin.getTemplateName();
        }

        @Override
        public List<MustacheTagInfo> getChildTags() {
            return AbstractSegment.this.getDirectChildTags();
        }

        public String toString() {
            return String.format("%s:%s %s", new Object[]{this.getType(), this.getText(), AbstractSegment.this.getOrigin()});
        }
    }
}

