/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import org.trimou.engine.resolver.Mapper;

public final class ImmutableIterationMeta
implements Mapper {
    private final String alias;
    private final int size;
    private final int index;
    private final String valueAlias;
    private final Object value;

    public ImmutableIterationMeta(String alias, int size, int index) {
        this(alias, size, index, null, null);
    }

    public ImmutableIterationMeta(String alias, int size, int index, String valueAlias, Object value) {
        this.alias = alias;
        this.size = size;
        this.index = index;
        this.valueAlias = valueAlias;
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public int getPosition() {
        return this.index - 1;
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    public boolean isFirst() {
        return this.index == 1;
    }

    public boolean isLast() {
        return this.index == this.size;
    }

    public boolean isOdd() {
        return !this.isEven();
    }

    public boolean isEven() {
        return this.index % 2 == 0;
    }

    public String getIndexParity() {
        return this.isEven() ? "even" : "odd";
    }

    public String getValueAlias() {
        return this.valueAlias;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Object get(String key) {
        if (this.alias.equals(key)) {
            return this;
        }
        if (this.valueAlias != null && this.valueAlias.equals(key)) {
            return this.value;
        }
        if ("iterIndex".equals(key)) {
            return this.getIndex();
        }
        if ("iterHasNext".equals(key)) {
            return this.hasNext();
        }
        if ("iterIsFirst".equals(key)) {
            return this.isFirst();
        }
        if ("iterIsLast".equals(key)) {
            return this.isLast();
        }
        return null;
    }
}

