/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.Options;

public class CacheHelper
extends BasicSectionHelper {
    public static final ConfigurationKey FRAGMENT_CACHE_MAX_SIZE_KEY = new SimpleConfigurationKey(CacheHelper.class.getName() + ".fragmentCacheMaxSize", 500L);
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheHelper.class);
    private volatile ComputingCache<Key, Fragment> fragments;

    @Override
    public void execute(Options options) {
        Fragment fragment;
        Map<String, Object> hash = options.getHash();
        Object key = hash.get("key");
        Object guard = hash.get("guard");
        Object expire = hash.get("expire");
        Object unit = expire != null ? hash.get("unit") : null;
        StringBuilder fragmentKey = new StringBuilder();
        fragmentKey.append(options.getTagInfo().getTemplateName());
        fragmentKey.append(options.getTagInfo().getLine());
        if (key != null) {
            fragmentKey.append(key.toString());
        }
        if ((fragment = this.fragments.get(new Key(fragmentKey.toString(), options))).getHits() > 0L && (this.isExpired(fragment, expire, unit) || this.isGuardCompromised(fragment, guard))) {
            fragment.update(CacheHelper.getContent(options), guard);
        }
        fragment.touch();
        options.append(fragment.getContent());
    }

    @Override
    public void init() {
        super.init();
        this.fragments = this.configuration.getComputingCacheFactory().create(CacheHelper.class.getName(), new ComputingCache.Function<Key, Fragment>(){

            @Override
            public Fragment compute(Key key) {
                Fragment fragment = new Fragment();
                fragment.update(CacheHelper.getContent(key.getOptions()), key.getOptions().getHash().get("guard"));
                key.cleanupAfterCompute();
                return fragment;
            }
        }, null, this.configuration.getLongPropertyValue(FRAGMENT_CACHE_MAX_SIZE_KEY), null);
    }

    @Override
    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(FRAGMENT_CACHE_MAX_SIZE_KEY);
    }

    @Override
    protected int numberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void validate(HelperDefinition definition) {
        super.validate(definition);
        Map<String, Object> hash = definition.getHash();
        if (hash.containsKey("expire")) {
            Object unit;
            Object expire = hash.get("expire");
            if (!(expire instanceof HelperDefinition.ValuePlaceholder)) {
                try {
                    Long.valueOf(expire.toString());
                }
                catch (NumberFormatException e) {
                    throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, (Throwable)e);
                }
            }
            if ((unit = hash.get("unit")) != null && !(unit instanceof TimeUnit) && !(unit instanceof HelperDefinition.ValuePlaceholder)) {
                try {
                    TimeUnit.valueOf(unit.toString());
                }
                catch (Exception e) {
                    throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, (Throwable)e);
                }
            }
        }
        if (!hash.containsKey("expire") && !hash.containsKey("guard")) {
            LOGGER.info("Cache fragment will not be automatically updated [helper: {}, template: {}, line: {}]", new Object[]{this.getClass().getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
        }
    }

    public void invalidateFragments() {
        if (this.fragments == null) {
            return;
        }
        this.fragments.clear();
    }

    public void invalidateFragments(final String keyPart) {
        if (this.fragments == null || keyPart == null) {
            return;
        }
        this.fragments.invalidate(new ComputingCache.KeyPredicate<Key>(){

            @Override
            public boolean apply(Key fragmentKey) {
                return fragmentKey.getKey().contains(keyPart);
            }
        });
    }

    @Override
    protected Optional<Set<String>> getSupportedHashKeys() {
        return Optional.of((Object)ImmutableSet.of((Object)"key", (Object)"guard", (Object)"expire", (Object)"unit"));
    }

    private boolean isExpired(Fragment fragment, Object expire, Object unit) {
        Long duration;
        TimeUnit timeUnit;
        if (expire == null) {
            return false;
        }
        if (unit != null) {
            if (unit instanceof TimeUnit) {
                timeUnit = (TimeUnit)((Object)unit);
            } else {
                try {
                    timeUnit = TimeUnit.valueOf(unit.toString());
                }
                catch (Exception e) {
                    throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, (Throwable)e);
                }
            }
        } else {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if (expire instanceof Long) {
            duration = (Long)expire;
        } else if (expire instanceof Integer) {
            duration = ((Integer)expire).longValue();
        } else {
            try {
                duration = Long.valueOf(expire.toString());
            }
            catch (Exception e) {
                throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, (Throwable)e);
            }
        }
        return System.currentTimeMillis() - fragment.getLastUsed() > timeUnit.toMillis(duration);
    }

    private boolean isGuardCompromised(Fragment fragment, Object guard) {
        if (guard == null) {
            return false;
        }
        return !guard.toString().equals(fragment.getGuard());
    }

    private static String getContent(Options options) {
        StringBuilder content = new StringBuilder();
        options.fn(content);
        return content.toString();
    }

    private static class Key {
        private final String key;
        private Options options;

        private Key(String key, Options options) {
            this.key = key;
            this.options = options;
        }

        void cleanupAfterCompute() {
            this.options = null;
        }

        String getKey() {
            return this.key;
        }

        Options getOptions() {
            return this.options;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }

    private static class Fragment {
        private final AtomicLong hits = new AtomicLong(0L);
        private final AtomicLong lastUsed = new AtomicLong();
        private final AtomicReference<String> content = new AtomicReference();
        private final AtomicReference<String> guard = new AtomicReference();

        private Fragment() {
        }

        String getContent() {
            return this.content.get();
        }

        void touch() {
            this.hits.incrementAndGet();
            this.lastUsed.set(System.currentTimeMillis());
        }

        void update(String content, Object guard) {
            this.content.set(content);
            if (guard != null) {
                this.guard.set(guard.toString());
            }
        }

        Long getLastUsed() {
            return this.lastUsed.get();
        }

        Long getHits() {
            return this.hits.get();
        }

        String getGuard() {
            return this.guard.get();
        }
    }
}

