/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Options;

abstract class MatchingSectionHelper
extends BasicSectionHelper {
    private static final Logger logger = LoggerFactory.getLogger(MatchingSectionHelper.class);
    private static final Set<String> SUPPORTED_HASH_KEYS = ImmutableSet.builder().add((Object)"logic").add((Object)"else").build();
    private final String elseStartDelimiter;
    private final Pattern elsePattern;

    MatchingSectionHelper() {
        this(EngineConfigurationKey.START_DELIMITER.getDefaultValue().toString().substring(0, 1), EngineConfigurationKey.END_DELIMITER.getDefaultValue().toString().substring(0, 1));
    }

    MatchingSectionHelper(String elseStartDelimiter, String elseEndDelimiter) {
        this.elseStartDelimiter = elseStartDelimiter;
        this.elsePattern = MatchingSectionHelper.initElsePattern(elseStartDelimiter, elseEndDelimiter);
    }

    @Override
    public void execute(Options options) {
        if (options.getParameters().isEmpty() && this.isMatching(options.peek()) || this.matches(options.getHash(), options.getParameters())) {
            options.fn();
        } else {
            Object elseBlock = this.getHashValue(options, "else");
            if (elseBlock != null) {
                String elseString = elseBlock.toString();
                if (elseString.contains(this.elseStartDelimiter)) {
                    this.append(options, this.interpolate(elseString, options));
                } else {
                    this.append(options, elseString);
                }
            }
        }
    }

    @Override
    protected Optional<Set<String>> getSupportedHashKeys() {
        return Optional.of(SUPPORTED_HASH_KEYS);
    }

    protected EvaluationLogic getDefaultLogic() {
        return EvaluationLogic.AND;
    }

    protected abstract boolean isMatching(Object var1);

    protected boolean hasEmptyParamsSupport() {
        return false;
    }

    @Override
    protected int numberOfRequiredParameters() {
        return this.hasEmptyParamsSupport() ? 0 : super.numberOfRequiredParameters();
    }

    private boolean matches(Map<String, Object> hash, List<Object> params) {
        if (params.size() == 1) {
            return this.isMatching(params.get(0));
        }
        EvaluationLogic logic = this.getLogic(hash);
        for (Object param : params) {
            Boolean value = logic.test(this.isMatching(param));
            if (value == null) continue;
            return value;
        }
        return logic.defaultResult();
    }

    private EvaluationLogic getLogic(Map<String, Object> hash) {
        if (hash.isEmpty() || !hash.containsKey("logic")) {
            return this.getDefaultLogic();
        }
        String customLogic = hash.get("logic").toString();
        EvaluationLogic logic = EvaluationLogic.parse(customLogic);
        if (logic == null) {
            logger.warn("Unsupported evaluation logic specified: {}, using the default one: {}", (Object)customLogic, (Object)this.getDefaultLogic());
            logic = this.getDefaultLogic();
        }
        return logic;
    }

    private String interpolate(String elseString, Options options) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = this.elsePattern.matcher(elseString);
        while (matcher.find()) {
            Object value = options.getValue(matcher.group(2).trim());
            String replacement = value != null ? value.toString() : "";
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    static Pattern initElsePattern(String elseStartDelimiter, String elseEndDelimiter) {
        return Pattern.compile("(" + Pattern.quote(elseStartDelimiter) + ")(.*?)(" + Pattern.quote(elseEndDelimiter) + ")");
    }

    protected static enum EvaluationLogic {
        OR{

            @Override
            Boolean test(boolean isMatching) {
                return isMatching ? Boolean.valueOf(true) : null;
            }

            @Override
            boolean defaultResult() {
                return false;
            }
        }
        ,
        AND{

            @Override
            Boolean test(boolean isMatching) {
                return !isMatching ? Boolean.valueOf(false) : null;
            }

            @Override
            boolean defaultResult() {
                return true;
            }
        };


        abstract Boolean test(boolean var1);

        abstract boolean defaultResult();

        public static EvaluationLogic parse(String value) {
            for (EvaluationLogic logic : EvaluationLogic.values()) {
                if (!value.equalsIgnoreCase(logic.toString())) continue;
                return logic;
            }
            return null;
        }
    }
}

