/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicHelper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.handlebars.Options;

public class NumericExpressionHelper
extends BasicHelper {
    private final Operator defaultOperator;

    public static HelpersBuilder forEachOperator() {
        HelpersBuilder builder = HelpersBuilder.empty();
        for (Operator operator : Operator.values()) {
            builder.add(operator.toString().toLowerCase(), new NumericExpressionHelper(operator));
        }
        return builder;
    }

    public NumericExpressionHelper() {
        this(Operator.EQ);
    }

    public NumericExpressionHelper(Operator defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    @Override
    public void execute(Options options) {
        Operator operator = this.initOperator(options);
        if (operator.getMinParams() > options.getParameters().size()) {
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "More parameters required [helper: %s, template: %s, line: %s]", NumericExpressionHelper.class.getName(), options.getTagInfo().getTemplateName(), options.getTagInfo().getLine());
        }
        boolean result = operator.evaluate(options);
        if (result) {
            if (this.isSection(options)) {
                options.fn();
            } else {
                Object outputValue = this.getHashValue(options, "out");
                String output = outputValue != null ? outputValue.toString() : Boolean.TRUE.toString();
                this.append(options, output);
            }
        }
    }

    @Override
    public void validate(HelperDefinition definition) {
        super.validate(definition);
        Object value = definition.getHash().get("op");
        Object operator = value == null ? Operator.EQ : (value instanceof HelperDefinition.ValuePlaceholder ? null : Operator.from(value.toString()));
        if (operator != null && operator.getMinParams() > definition.getParameters().size()) {
            throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Operator requires more parameters [helper: %s, template: %s, line: %s]", this.getClass().getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine());
        }
    }

    private Operator initOperator(Options options) {
        Operator operator = null;
        Object value = this.getHashValue(options, "op");
        if (value != null) {
            operator = Operator.from(value.toString());
        }
        return operator != null ? operator : this.defaultOperator;
    }

    private static BigDecimal getDecimal(int index, Options options) {
        return NumericExpressionHelper.getDecimal(options.getParameters().get(index), options);
    }

    static BigDecimal getDecimal(Object value, Options options) {
        BigDecimal decimal;
        if (value instanceof BigDecimal) {
            decimal = (BigDecimal)value;
        } else if (value instanceof BigInteger) {
            decimal = new BigDecimal((BigInteger)value);
        } else if (value instanceof Long) {
            decimal = new BigDecimal((Long)value);
        } else if (value instanceof Integer) {
            decimal = new BigDecimal((Integer)value);
        } else if (value instanceof Double) {
            decimal = new BigDecimal((Double)value);
        } else if (value instanceof String) {
            decimal = new BigDecimal(value.toString());
        } else {
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "Parameter is not valid [param: %s, helper: %s, template: %s, line: %s]", value, NumericExpressionHelper.class.getName(), options.getTagInfo().getTemplateName(), options.getTagInfo().getLine());
        }
        return decimal;
    }

    private static class InverseEvaluator
    implements Evaluator {
        private final Evaluator evaluator;

        InverseEvaluator(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean evaluate(Options options) {
            return !this.evaluator.evaluate(options);
        }
    }

    private static class EqualsEvaluator
    implements Evaluator {
        private EqualsEvaluator() {
        }

        @Override
        public boolean evaluate(Options options) {
            BigDecimal val2;
            BigDecimal val1 = NumericExpressionHelper.getDecimal(0, options);
            return val1.compareTo(val2 = NumericExpressionHelper.getDecimal(1, options)) == 0;
        }
    }

    private static final class InEvaluator
    implements Evaluator {
        private InEvaluator() {
        }

        @Override
        public boolean evaluate(Options options) {
            BigDecimal val = NumericExpressionHelper.getDecimal(0, options);
            for (int i = 1; i < options.getParameters().size(); ++i) {
                Object toTest = options.getParameters().get(i);
                if (toTest == null) continue;
                if (toTest instanceof Iterable) {
                    Iterator iterator = ((Iterable)toTest).iterator();
                    while (iterator.hasNext()) {
                        if (!this.test(val, NumericExpressionHelper.getDecimal(iterator.next(), options))) continue;
                        return true;
                    }
                    continue;
                }
                if (toTest.getClass().isArray()) {
                    int length = Array.getLength(toTest);
                    for (int j = 0; j < length; ++j) {
                        if (!this.test(val, NumericExpressionHelper.getDecimal(Array.get(toTest, j), options))) continue;
                        return true;
                    }
                    continue;
                }
                if (!this.test(val, NumericExpressionHelper.getDecimal(toTest, options))) continue;
                return true;
            }
            return false;
        }

        private boolean test(BigDecimal val1, BigDecimal val2) {
            return val1.compareTo(val2) == 0;
        }
    }

    static interface Evaluator {
        public boolean evaluate(Options var1);
    }

    public static enum Operator {
        EQ(new EqualsEvaluator()),
        NEQ(new InverseEvaluator(new EqualsEvaluator())),
        GT(new Evaluator(){

            @Override
            public boolean evaluate(Options options) {
                BigDecimal val2;
                BigDecimal val1 = NumericExpressionHelper.getDecimal(0, options);
                return val1.compareTo(val2 = NumericExpressionHelper.getDecimal(1, options)) > 0;
            }
        }),
        GE(new Evaluator(){

            @Override
            public boolean evaluate(Options options) {
                BigDecimal val2;
                BigDecimal val1 = NumericExpressionHelper.getDecimal(0, options);
                return val1.compareTo(val2 = NumericExpressionHelper.getDecimal(1, options)) >= 0;
            }
        }),
        LT(new Evaluator(){

            @Override
            public boolean evaluate(Options options) {
                BigDecimal val2;
                BigDecimal val1 = NumericExpressionHelper.getDecimal(0, options);
                return val1.compareTo(val2 = NumericExpressionHelper.getDecimal(1, options)) < 0;
            }
        }),
        LE(new Evaluator(){

            @Override
            public boolean evaluate(Options options) {
                BigDecimal val2;
                BigDecimal val1 = NumericExpressionHelper.getDecimal(0, options);
                return val1.compareTo(val2 = NumericExpressionHelper.getDecimal(1, options)) <= 0;
            }
        }),
        NEG(1, new Evaluator(){

            @Override
            public boolean evaluate(Options options) {
                return NumericExpressionHelper.getDecimal(0, options).compareTo(BigDecimal.ZERO) < 0;
            }
        }),
        POS(1, new Evaluator(){

            @Override
            public boolean evaluate(Options options) {
                return NumericExpressionHelper.getDecimal(0, options).compareTo(BigDecimal.ZERO) > 0;
            }
        }),
        IN(new InEvaluator()),
        NIN(new InverseEvaluator(new InEvaluator()));

        private final int minParams;
        private final Evaluator evaluator;

        private Operator(Evaluator evaluator) {
            this(2, evaluator);
        }

        private Operator(int minParams, Evaluator evaluator) {
            this.minParams = minParams;
            this.evaluator = evaluator;
        }

        public int getMinParams() {
            return this.minParams;
        }

        public boolean evaluate(Options options) {
            return this.evaluator.evaluate(options);
        }

        static Operator from(String value) {
            if (value != null) {
                for (Operator operator : Operator.values()) {
                    if (!operator.toString().equalsIgnoreCase(value)) continue;
                    return operator;
                }
            }
            return null;
        }
    }
}

