/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.Dispatcher;
import twitter4j.HttpResponse;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.RawStreamListener;
import twitter4j.StallWarning;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusListener;
import twitter4j.StatusStreamBase;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.UserStreamListener;
import twitter4j.conf.Configuration;

class StatusStreamImpl
extends StatusStreamBase {
    String line;
    static final RawStreamListener[] EMPTY = new RawStreamListener[0];

    StatusStreamImpl(Dispatcher dispatcher, InputStream stream, Configuration conf) throws IOException {
        super(dispatcher, stream, conf);
    }

    StatusStreamImpl(Dispatcher dispatcher, HttpResponse response, Configuration conf) throws IOException {
        super(dispatcher, response, conf);
    }

    protected void onClose() {
    }

    public void next(StatusListener listener) throws TwitterException {
        this.handleNextElement(new StatusListener[]{listener}, EMPTY);
    }

    public void next(StreamListener[] listeners, RawStreamListener[] rawStreamListeners) throws TwitterException {
        this.handleNextElement(listeners, rawStreamListeners);
    }

    protected String parseLine(String line) {
        this.line = line;
        return line;
    }

    protected void onMessage(String rawString, RawStreamListener[] listeners) throws TwitterException {
        for (RawStreamListener listener : listeners) {
            listener.onMessage(rawString);
        }
    }

    protected void onStatus(JSONObject json, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((StatusListener)listener).onStatus(this.asStatus(json));
        }
    }

    protected void onDelete(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            JSONObject deletionNotice = json.getJSONObject("delete");
            if (deletionNotice.has("status")) {
                ((StatusListener)listener).onDeletionNotice((StatusDeletionNotice)new StatusDeletionNoticeImpl(deletionNotice.getJSONObject("status")));
                continue;
            }
            JSONObject directMessage = deletionNotice.getJSONObject("direct_message");
            ((UserStreamListener)listener).onDeletionNotice(ParseUtil.getLong((String)"id", (JSONObject)directMessage), ParseUtil.getLong((String)"user_id", (JSONObject)directMessage));
        }
    }

    protected void onLimit(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            ((StatusListener)listener).onTrackLimitationNotice(ParseUtil.getInt((String)"track", (JSONObject)json.getJSONObject("limit")));
        }
    }

    protected void onStallWarning(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            ((StatusListener)listener).onStallWarning(new StallWarning(json));
        }
    }

    protected void onScrubGeo(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        JSONObject scrubGeo = json.getJSONObject("scrub_geo");
        for (StreamListener listener : listeners) {
            ((StatusListener)listener).onScrubGeo(ParseUtil.getLong((String)"user_id", (JSONObject)scrubGeo), ParseUtil.getLong((String)"up_to_status_id", (JSONObject)scrubGeo));
        }
    }

    public void onException(Exception e, StreamListener[] listeners) {
        for (StreamListener listener : listeners) {
            listener.onException(e);
        }
    }
}

