/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.preferences.shared.PropertyFormOptions;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;

@Portable
public class PreferenceHierarchyElement<T> {
    private String id;
    private BasePreferencePortable<T> portablePreference;
    private List<PreferenceHierarchyElement<?>> children;
    private boolean shared;
    private boolean root;
    private String bundleKey;
    private Map<String, String> bundleKeyByProperty;
    private Map<String, String> helpBundleKeyByProperty;
    private Map<String, PropertyFormOptions[]> formOptionsByProperty;

    public PreferenceHierarchyElement() {
        this(null, null, false, false, null);
    }

    public PreferenceHierarchyElement(String id, BasePreferencePortable<T> portablePreference, boolean shared, boolean root, String bundleKey) {
        this(id, portablePreference, new ArrayList(), shared, root, bundleKey, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, PropertyFormOptions[]>());
    }

    public PreferenceHierarchyElement(@MapsTo(value="id") String id, @MapsTo(value="portablePreference") BasePreferencePortable<T> portablePreference, @MapsTo(value="children") List<PreferenceHierarchyElement<?>> children, @MapsTo(value="shared") boolean shared, @MapsTo(value="root") boolean root, @MapsTo(value="bundleKey") String bundleKey, @MapsTo(value="bundleKeyByProperty") Map<String, String> bundleKeyByProperty, @MapsTo(value="helpBundleKeyByProperty") Map<String, String> helpBundleKeyByProperty, @MapsTo(value="formOptionsByProperty") Map<String, PropertyFormOptions[]> formOptionsByProperty) {
        this.id = id;
        this.portablePreference = portablePreference;
        this.children = children;
        this.shared = shared;
        this.root = root;
        this.bundleKey = bundleKey;
        this.bundleKeyByProperty = bundleKeyByProperty;
        this.helpBundleKeyByProperty = helpBundleKeyByProperty;
        this.formOptionsByProperty = formOptionsByProperty;
    }

    public boolean isSelectable() {
        boolean hasProperties = this.bundleKeyByProperty != null && this.bundleKeyByProperty.size() > 0;
        return hasProperties;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BasePreferencePortable<T> getPortablePreference() {
        return this.portablePreference;
    }

    public void setPortablePreference(BasePreferencePortable<T> portablePreference) {
        this.portablePreference = portablePreference;
    }

    public List<PreferenceHierarchyElement<?>> getChildren() {
        return this.children;
    }

    public void setChildren(List<PreferenceHierarchyElement<?>> children) {
        this.children = children;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public String getBundleKey() {
        return this.bundleKey;
    }

    public void setBundleKey(String bundleKey) {
        this.bundleKey = bundleKey;
    }

    public void addPropertyBundleKey(String propertyFieldName, String bundleKey) {
        this.bundleKeyByProperty.put(propertyFieldName, bundleKey);
    }

    public Map<String, String> getBundleKeyByProperty() {
        return this.bundleKeyByProperty;
    }

    public void addPropertyHelpBundleKey(String propertyFieldName, String helpBundleKey) {
        this.helpBundleKeyByProperty.put(propertyFieldName, helpBundleKey);
    }

    public Map<String, String> getHelpBundleKeyByProperty() {
        return this.helpBundleKeyByProperty;
    }

    public void addPropertyFormOptions(String propertyFieldName, PropertyFormOptions[] formOptions) {
        this.formOptionsByProperty.put(propertyFieldName, formOptions);
    }

    public Map<String, PropertyFormOptions[]> getFormOptionsByProperty() {
        return this.formOptionsByProperty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreferenceHierarchyElement)) {
            return false;
        }
        PreferenceHierarchyElement that = (PreferenceHierarchyElement)o;
        if (this.isShared() != that.isShared()) {
            return false;
        }
        if (this.isRoot() != that.isRoot()) {
            return false;
        }
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getPortablePreference() != null ? !this.getPortablePreference().equals(that.getPortablePreference()) : that.getPortablePreference() != null) {
            return false;
        }
        if (this.getChildren() != null ? !this.getChildren().equals(that.getChildren()) : that.getChildren() != null) {
            return false;
        }
        if (this.getBundleKey() != null ? !this.getBundleKey().equals(that.getBundleKey()) : that.getBundleKey() != null) {
            return false;
        }
        if (this.getBundleKeyByProperty() != null ? !this.getBundleKeyByProperty().equals(that.getBundleKeyByProperty()) : that.getBundleKeyByProperty() != null) {
            return false;
        }
        if (this.getHelpBundleKeyByProperty() != null ? !this.getHelpBundleKeyByProperty().equals(that.getHelpBundleKeyByProperty()) : that.getHelpBundleKeyByProperty() != null) {
            return false;
        }
        return !(this.getFormOptionsByProperty() == null ? that.getFormOptionsByProperty() != null : !this.getFormOptionsByProperty().equals(that.getFormOptionsByProperty()));
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.getPortablePreference() != null ? this.getPortablePreference().hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.getChildren() != null ? this.getChildren().hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.isShared() ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this.isRoot() ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this.getBundleKey() != null ? this.getBundleKey().hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.getBundleKeyByProperty() != null ? this.getBundleKeyByProperty().hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.getHelpBundleKeyByProperty() != null ? this.getHelpBundleKeyByProperty().hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.getFormOptionsByProperty() != null ? this.getFormOptionsByProperty().hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

