/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Properties;
import java.util.Set;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.mock.Mock;
import org.unitils.mock.MockUnitils;
import org.unitils.mock.PartialMock;
import org.unitils.mock.annotation.AfterCreateMock;
import org.unitils.mock.annotation.Dummy;
import org.unitils.mock.core.MockObject;
import org.unitils.mock.core.PartialMockObject;
import org.unitils.mock.dummy.DummyObjectUtil;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public class MockModule
implements Module {
    public void init(Properties configuration) {
    }

    public void afterInit() {
    }

    protected void createAndInjectMocksIntoTest(Object testObject) {
        Set mockFields = ReflectionUtils.getFieldsOfType(testObject.getClass(), Mock.class, (boolean)false);
        for (Field field : mockFields) {
            Mock mock = (Mock)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            if (mock != null) {
                mock.resetBehavior();
                continue;
            }
            mock = this.createMock(testObject, field.getName(), this.getMockedClass(field));
            this.injectMock(testObject, field, mock);
        }
    }

    protected void createAndInjectPartialMocksIntoTest(Object testObject) {
        Set partialMockFields = ReflectionUtils.getFieldsOfType(testObject.getClass(), PartialMock.class, (boolean)false);
        for (Field field : partialMockFields) {
            Mock mock = (Mock)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            if (mock != null) {
                mock.resetBehavior();
                continue;
            }
            mock = this.createPartialMock(testObject, field.getName(), this.getMockedClass(field));
            this.injectMock(testObject, field, mock);
        }
    }

    protected <T> Mock<T> createMock(Object testObject, String name, Class<?> type) {
        return new MockObject(name, type, testObject);
    }

    protected <T> Mock<T> createPartialMock(Object testObject, String name, Class<?> type) {
        return new PartialMockObject(name, type, testObject);
    }

    protected Class<?> getMockedClass(Field field) {
        try {
            Type type = ReflectionUtils.getGenericType((Field)field);
            return ReflectionUtils.getClassForType((Type)type);
        }
        catch (UnitilsException e) {
            throw new UnitilsException("Unable to determine type of mock. A mock should be declared using the generic Mock<YourTypeToMock> or PartialMock<YourTypeToMock> types. Field: " + field, (Throwable)e);
        }
    }

    protected void injectMock(Object testObject, Field field, Mock<?> mock) {
        ReflectionUtils.setFieldValue((Object)testObject, (Field)field, mock);
        this.callAfterCreateMockMethods(testObject, mock, field.getName());
    }

    protected void createAndInjectDummiesIntoTest(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), Dummy.class);
        for (Field field : fields) {
            Object dummy = DummyObjectUtil.createDummy(field.getType());
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, dummy);
        }
    }

    protected void callAfterCreateMockMethods(Object testObject, Mock<?> mockObject, String name) {
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), AfterCreateMock.class);
        for (Method method : methods) {
            try {
                ReflectionUtils.invokeMethod((Object)testObject, (Method)method, (Object[])new Object[]{mockObject, name, ((MockObject)mockObject).getMockedType()});
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("An exception occurred while invoking an after create mock method.", (Throwable)e);
            }
            catch (Exception e) {
                throw new UnitilsException("Unable to invoke after create mock method. Ensure that this method has following signature: void myMethod(Object mock, String name, Class type)", (Throwable)e);
            }
        }
    }

    public TestListener getTestListener() {
        return new MockTestListener();
    }

    protected class MockTestListener
    extends TestListener {
        protected MockTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            MockModule.this.createAndInjectPartialMocksIntoTest(testObject);
            MockModule.this.createAndInjectMocksIntoTest(testObject);
            MockModule.this.createAndInjectDummiesIntoTest(testObject);
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable testThrowable) {
            if (testThrowable != null) {
                MockUnitils.logFullScenarioReport();
            }
        }
    }
}

