/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core;

import org.unitils.core.UnitilsException;
import org.unitils.mock.core.BehaviorDefiningInvocation;
import org.unitils.mock.core.BehaviorDefiningInvocations;
import org.unitils.mock.core.ObservedInvocation;
import org.unitils.mock.core.Scenario;
import org.unitils.mock.core.matching.MatchingInvocationBuilder;
import org.unitils.mock.core.proxy.ProxyFactory;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.core.proxy.ProxyInvocationHandler;
import org.unitils.mock.mockbehavior.MockBehavior;
import org.unitils.mock.mockbehavior.ValidatableMockBehavior;
import org.unitils.mock.mockbehavior.impl.DefaultValueReturningMockBehavior;

public class MockProxy<T> {
    protected T proxy;
    protected BehaviorDefiningInvocations oneTimeMatchingBehaviorDefiningInvocations;
    protected BehaviorDefiningInvocations alwaysMatchingBehaviorDefiningInvocations;
    protected Scenario scenario;
    protected MatchingInvocationBuilder matchingInvocationBuilder;

    public MockProxy(String mockName, Class<T> mockedType, BehaviorDefiningInvocations oneTimeMatchingBehaviorDefiningInvocations, BehaviorDefiningInvocations alwaysMatchingBehaviorDefiningInvocations, Scenario scenario, MatchingInvocationBuilder matchingInvocationBuilder) {
        this.oneTimeMatchingBehaviorDefiningInvocations = oneTimeMatchingBehaviorDefiningInvocations;
        this.alwaysMatchingBehaviorDefiningInvocations = alwaysMatchingBehaviorDefiningInvocations;
        this.scenario = scenario;
        this.matchingInvocationBuilder = matchingInvocationBuilder;
        this.proxy = ProxyFactory.createProxy(mockName, new InvocationHandler(), mockedType, Cloneable.class);
    }

    public T getProxy() {
        return this.proxy;
    }

    protected Object handleMockInvocation(ProxyInvocation proxyInvocation) throws Throwable {
        this.matchingInvocationBuilder.assertNotExpectingInvocation();
        BehaviorDefiningInvocation behaviorDefiningInvocation = this.getMatchingBehaviorDefiningInvocation(proxyInvocation);
        MockBehavior mockBehavior = this.getValidMockBehavior(proxyInvocation, behaviorDefiningInvocation);
        ObservedInvocation observedInvocation = new ObservedInvocation(proxyInvocation, behaviorDefiningInvocation, mockBehavior);
        this.scenario.addObservedMockInvocation(observedInvocation);
        Throwable throwable = null;
        Object result = null;
        if (mockBehavior != null) {
            try {
                result = mockBehavior.execute(proxyInvocation);
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        observedInvocation.setResult(result);
        if (throwable != null) {
            throw throwable;
        }
        return result;
    }

    protected BehaviorDefiningInvocation getMatchingBehaviorDefiningInvocation(ProxyInvocation proxyInvocation) throws Throwable {
        BehaviorDefiningInvocation behaviorDefiningInvocation = this.oneTimeMatchingBehaviorDefiningInvocations.getMatchingBehaviorDefiningInvocation(proxyInvocation);
        if (behaviorDefiningInvocation == null) {
            behaviorDefiningInvocation = this.alwaysMatchingBehaviorDefiningInvocations.getMatchingBehaviorDefiningInvocation(proxyInvocation);
        }
        return behaviorDefiningInvocation;
    }

    protected MockBehavior getValidMockBehavior(ProxyInvocation proxyInvocation, BehaviorDefiningInvocation behaviorDefiningInvocation) {
        if (behaviorDefiningInvocation != null) {
            MockBehavior mockBehavior = behaviorDefiningInvocation.getMockBehavior();
            this.assertCanExecute(mockBehavior, proxyInvocation, behaviorDefiningInvocation);
            return mockBehavior;
        }
        return this.getDefaultMockBehavior(proxyInvocation);
    }

    protected void assertCanExecute(MockBehavior mockBehavior, ProxyInvocation proxyInvocation, BehaviorDefiningInvocation behaviorDefiningInvocation) {
        if (!(mockBehavior instanceof ValidatableMockBehavior)) {
            return;
        }
        ValidatableMockBehavior validatableMockBehavior = (ValidatableMockBehavior)mockBehavior;
        try {
            validatableMockBehavior.assertCanExecute(proxyInvocation);
        }
        catch (UnitilsException e) {
            e.setStackTrace(behaviorDefiningInvocation.getInvokedAtTrace());
            throw e;
        }
    }

    protected MockBehavior getDefaultMockBehavior(ProxyInvocation proxyInvocation) {
        if (proxyInvocation.getMethod().getReturnType() == Void.TYPE) {
            return null;
        }
        return new DefaultValueReturningMockBehavior();
    }

    protected class InvocationHandler
    implements ProxyInvocationHandler {
        protected InvocationHandler() {
        }

        @Override
        public Object handleInvocation(ProxyInvocation invocation) throws Throwable {
            return MockProxy.this.handleMockInvocation(invocation);
        }
    }
}

