/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.DirectoryScanner;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.changes.ChangeSet;
import org.vafer.jdeb.changes.ChangesProvider;
import org.vafer.jdeb.control.FilteredConfigurationFile;
import org.vafer.jdeb.descriptors.ChangesDescriptor;
import org.vafer.jdeb.descriptors.PackageDescriptor;
import org.vafer.jdeb.mapping.PermMapper;
import org.vafer.jdeb.shaded.compress.compress.archivers.ar.ArArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.ar.ArArchiveOutputStream;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarArchiveOutputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorException;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorStreamFactory;
import org.vafer.jdeb.shaded.compress.io.output.NullOutputStream;
import org.vafer.jdeb.signing.SigningUtils;
import org.vafer.jdeb.utils.InformationInputStream;
import org.vafer.jdeb.utils.InformationOutputStream;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public class Processor {
    private static final Set<String> CONFIGURATION_FILENAMES = new HashSet<String>(Arrays.asList("conffiles", "preinst", "postinst", "prerm", "postrm"));
    private final Console console;
    private final VariableResolver resolver;
    private List<FilteredConfigurationFile> configurationFiles;

    public Processor(Console pConsole, VariableResolver pResolver) {
        this.console = pConsole;
        this.resolver = pResolver;
        this.configurationFiles = new ArrayList<FilteredConfigurationFile>();
    }

    private void addTo(ArArchiveOutputStream pOutput, String pName, String pContent) throws IOException {
        byte[] content = pContent.getBytes();
        pOutput.putArchiveEntry(new ArArchiveEntry(pName, content.length));
        pOutput.write(content);
        pOutput.closeArchiveEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTo(ArArchiveOutputStream pOutput, String pName, File pContent) throws IOException {
        pOutput.putArchiveEntry(new ArArchiveEntry(pName, pContent.length()));
        FileInputStream input = new FileInputStream(pContent);
        try {
            Utils.copy(input, pOutput);
        }
        finally {
            ((InputStream)input).close();
        }
        pOutput.closeArchiveEntry();
    }

    public PackageDescriptor createDeb(File[] pControlFiles, DataProducer[] pData, File pOutput, String compression) throws PackagingException {
        File tempData = null;
        File tempControl = null;
        try {
            tempData = File.createTempFile("deb", "data");
            tempControl = File.createTempFile("deb", "control");
            this.console.info("Building data");
            StringBuilder md5s = new StringBuilder();
            BigInteger size = this.buildData(pData, tempData, md5s, compression);
            this.console.info("Building control");
            PackageDescriptor packageDescriptor = this.buildControl(pControlFiles, size, md5s, tempControl);
            if (!packageDescriptor.isValid()) {
                throw new PackagingException("Control file descriptor keys are invalid " + packageDescriptor.invalidKeys() + ". The following keys are mandatory " + Arrays.toString(PackageDescriptor.mandatoryKeys) + ". Please check your pom.xml/build.xml and your control file.");
            }
            pOutput.getParentFile().mkdirs();
            InformationOutputStream md5output = new InformationOutputStream(new FileOutputStream(pOutput), MessageDigest.getInstance("MD5"));
            InformationOutputStream sha1output = new InformationOutputStream(md5output, MessageDigest.getInstance("SHA1"));
            InformationOutputStream sha256output = new InformationOutputStream(sha1output, MessageDigest.getInstance("SHA-256"));
            ArArchiveOutputStream ar = new ArArchiveOutputStream(sha256output);
            this.addTo(ar, "debian-binary", "2.0\n");
            this.addTo(ar, "control.tar.gz", tempControl);
            this.addTo(ar, "data.tar" + this.getExtension(compression), tempData);
            ar.close();
            packageDescriptor.set("MD5", md5output.getHexDigest());
            packageDescriptor.set("SHA1", sha1output.getHexDigest());
            packageDescriptor.set("SHA256", sha256output.getHexDigest());
            packageDescriptor.set("Size", "" + md5output.getSize());
            packageDescriptor.set("File", pOutput.getName());
            PackageDescriptor packageDescriptor2 = packageDescriptor;
            return packageDescriptor2;
        }
        catch (Exception e) {
            throw new PackagingException("Could not create deb package", e);
        }
        finally {
            if (tempData != null && !tempData.delete()) {
                throw new PackagingException("Could not delete " + tempData);
            }
            if (tempControl != null && !tempControl.delete()) {
                throw new PackagingException("Could not delete " + tempControl);
            }
        }
    }

    private String getExtension(String pCompression) {
        if ("gzip".equals(pCompression)) {
            return ".gz";
        }
        if ("bzip2".equals(pCompression)) {
            return ".bz2";
        }
        return "";
    }

    public ChangesDescriptor createChanges(PackageDescriptor pPackageDescriptor, ChangesProvider pChangesProvider, InputStream pRing, String pKey, String pPassphrase, OutputStream pOutput) throws IOException, PackagingException {
        ChangeSet[] changeSets = pChangesProvider.getChangesSets();
        ChangesDescriptor changesDescriptor = new ChangesDescriptor(pPackageDescriptor, changeSets);
        changesDescriptor.set("Format", "1.8");
        if (changesDescriptor.get("Binary") == null) {
            changesDescriptor.set("Binary", changesDescriptor.get("Package"));
        }
        if (changesDescriptor.get("Source") == null) {
            changesDescriptor.set("Source", changesDescriptor.get("Package"));
        }
        StringBuilder checksumsSha1 = new StringBuilder("\n");
        checksumsSha1.append(' ').append(changesDescriptor.get("SHA1"));
        checksumsSha1.append(' ').append(changesDescriptor.get("Size"));
        checksumsSha1.append(' ').append(changesDescriptor.get("File"));
        changesDescriptor.set("Checksums-Sha1", checksumsSha1.toString());
        StringBuilder checksumsSha256 = new StringBuilder("\n");
        checksumsSha256.append(' ').append(changesDescriptor.get("SHA256"));
        checksumsSha256.append(' ').append(changesDescriptor.get("Size"));
        checksumsSha256.append(' ').append(changesDescriptor.get("File"));
        changesDescriptor.set("Checksums-Sha256", checksumsSha256.toString());
        StringBuilder files = new StringBuilder("\n");
        files.append(' ').append(changesDescriptor.get("MD5"));
        files.append(' ').append(changesDescriptor.get("Size"));
        files.append(' ').append(changesDescriptor.get("Section"));
        files.append(' ').append(changesDescriptor.get("Priority"));
        files.append(' ').append(changesDescriptor.get("File"));
        changesDescriptor.set("Files", files.toString());
        if (!changesDescriptor.isValid()) {
            throw new PackagingException("Changes file descriptor keys are invalid " + changesDescriptor.invalidKeys() + ". The following keys are mandatory " + Arrays.toString(ChangesDescriptor.mandatoryKeys) + ". Please check your pom.xml/build.xml and your control file.");
        }
        String changes = changesDescriptor.toString();
        byte[] changesBytes = changes.getBytes("UTF-8");
        if (pRing == null || pKey == null || pPassphrase == null) {
            pOutput.write(changesBytes);
            pOutput.close();
            return changesDescriptor;
        }
        this.console.info("Signing changes with key " + pKey);
        ByteArrayInputStream input = new ByteArrayInputStream(changesBytes);
        try {
            SigningUtils.clearSign(input, pRing, pKey, pPassphrase, pOutput);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pOutput.close();
        return changesDescriptor;
    }

    private PackageDescriptor buildControl(File[] pControlFiles, BigInteger pDataSize, StringBuilder pChecksums, File pOutput) throws IOException, ParseException {
        File dir = pOutput.getParentFile();
        if (!(dir == null || dir.exists() && dir.isDirectory())) {
            throw new IOException("Cannot write control file at '" + pOutput.getAbsolutePath() + "'");
        }
        TarArchiveOutputStream outputStream = new TarArchiveOutputStream(new GZIPOutputStream(new FileOutputStream(pOutput)));
        outputStream.setLongFileMode(2);
        PackageDescriptor packageDescriptor = null;
        for (File file : pControlFiles) {
            if (file.isDirectory()) {
                String pattern;
                boolean isDefaultExcludes = false;
                String[] arr$ = DirectoryScanner.getDefaultExcludes();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(isDefaultExcludes = DirectoryScanner.match((String)(pattern = arr$[i$]), (String)file.getAbsolutePath().replace("\\", "/"))); ++i$) {
                }
                if (isDefaultExcludes) continue;
                this.console.info("Found directory '" + file + "' in the control directory. Maybe you are pointing to wrong dir?");
                continue;
            }
            TarArchiveEntry entry = new TarArchiveEntry(file);
            String name = file.getName();
            entry.setName("./" + name);
            entry.setNames("root", "root");
            entry.setMode(PermMapper.toMode("755"));
            if (CONFIGURATION_FILENAMES.contains(name)) {
                FilteredConfigurationFile configurationFile = new FilteredConfigurationFile(file.getName(), new FileInputStream(file), this.resolver);
                this.configurationFiles.add(configurationFile);
                continue;
            }
            if ("control".equals(name)) {
                packageDescriptor = new PackageDescriptor(new FileInputStream(file), this.resolver);
                if (packageDescriptor.get("Date") == null) {
                    SimpleDateFormat fmt = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
                    packageDescriptor.set("Date", fmt.format(new Date()));
                }
                if (packageDescriptor.get("Distribution") == null) {
                    packageDescriptor.set("Distribution", "unknown");
                }
                if (packageDescriptor.get("Urgency") == null) {
                    packageDescriptor.set("Urgency", "low");
                }
                packageDescriptor.set("Installed-Size", pDataSize.divide(BigInteger.valueOf(1024L)).toString());
                String debFullName = System.getenv("DEBFULLNAME");
                String debEmail = System.getenv("DEBEMAIL");
                if (debFullName == null || debEmail == null) continue;
                String maintainer = debFullName + " <" + debEmail + ">";
                packageDescriptor.set("Maintainer", maintainer);
                this.console.info("Using maintainer '" + maintainer + "' from the environment variables.");
                continue;
            }
            InformationInputStream infoStream = new InformationInputStream(new FileInputStream(file));
            Utils.copy(infoStream, NullOutputStream.NULL_OUTPUT_STREAM);
            infoStream.close();
            InputStream in = new FileInputStream(file);
            if (infoStream.isShell() && !infoStream.hasUnixLineEndings()) {
                byte[] buf = Utils.toUnixLineEndings(in);
                entry.setSize(buf.length);
                in = new ByteArrayInputStream(buf);
            }
            outputStream.putArchiveEntry(entry);
            Utils.copy(in, outputStream);
            outputStream.closeArchiveEntry();
            ((InputStream)in).close();
        }
        if (packageDescriptor == null) {
            throw new FileNotFoundException("No 'control' found in " + Arrays.toString(pControlFiles));
        }
        for (FilteredConfigurationFile configurationFile : this.configurationFiles) {
            Processor.addControlEntry(configurationFile.getName(), configurationFile.toString(), outputStream);
        }
        Processor.addEntry("control", packageDescriptor.toString(), outputStream);
        Processor.addEntry("md5sums", pChecksums.toString(), outputStream);
        outputStream.close();
        return packageDescriptor;
    }

    private OutputStream compressedOutputStream(String pCompression, OutputStream outputStream) throws CompressorException {
        if ("none".equalsIgnoreCase(pCompression)) {
            return outputStream;
        }
        if ("gzip".equals(pCompression)) {
            pCompression = "gz";
        }
        return new CompressorStreamFactory().createCompressorOutputStream(pCompression, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigInteger buildData(DataProducer[] pData, File pOutput, final StringBuilder pChecksums, String pCompression) throws NoSuchAlgorithmException, IOException, CompressorException {
        File dir = pOutput.getParentFile();
        if (!(dir == null || dir.exists() && dir.isDirectory())) {
            throw new IOException("Cannot write data file at '" + pOutput.getAbsolutePath() + "'");
        }
        final TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream(this.compressedOutputStream(pCompression, new FileOutputStream(pOutput)));
        tarOutputStream.setLongFileMode(2);
        final MessageDigest digest = MessageDigest.getInstance("MD5");
        final Total dataSize = new Total();
        final ArrayList addedDirectories = new ArrayList();
        DataConsumer receiver = new DataConsumer(){

            @Override
            public void onEachDir(String dirname, String linkname, String user, int uid, String group, int gid, int mode, long size) throws IOException {
                dirname = this.fixPath(dirname);
                this.createParentDirectories(new File(dirname).getParent(), user, uid, group, gid);
                this.createDirectory(dirname, user, uid, group, gid, mode, 0L);
                Processor.this.console.info("dir: " + dirname);
            }

            @Override
            public void onEachFile(InputStream inputStream, String filename, String linkname, String user, int uid, String group, int gid, int mode, long size) throws IOException {
                filename = this.fixPath(filename);
                this.createParentDirectories(new File(filename).getParent(), user, uid, group, gid);
                TarArchiveEntry entry = new TarArchiveEntry(filename, true);
                entry.setUserName(user);
                entry.setUserId(uid);
                entry.setGroupName(group);
                entry.setGroupId(gid);
                entry.setMode(mode);
                entry.setSize(size);
                tarOutputStream.putArchiveEntry(entry);
                dataSize.add(size);
                digest.reset();
                Utils.copy(inputStream, new DigestOutputStream(tarOutputStream, digest));
                String md5 = Utils.toHex(digest.digest());
                tarOutputStream.closeArchiveEntry();
                Processor.this.console.info("file:" + entry.getName() + " size:" + entry.getSize() + " mode:" + entry.getMode() + " linkname:" + entry.getLinkName() + " username:" + entry.getUserName() + " userid:" + entry.getUserId() + " groupname:" + entry.getGroupName() + " groupid:" + entry.getGroupId() + " modtime:" + entry.getModTime() + " md5: " + md5);
                pChecksums.append(md5).append(" ").append(entry.getName()).append('\n');
            }

            @Override
            public void onEachLink(String path, String linkName, boolean symlink, String user, int uid, String group, int gid) throws IOException {
                path = this.fixPath(path);
                this.createParentDirectories(new File(path).getParent(), user, uid, group, gid);
                TarArchiveEntry entry = new TarArchiveEntry(path, symlink ? (byte)50 : 49);
                entry.setLinkName(linkName);
                tarOutputStream.putArchiveEntry(entry);
                tarOutputStream.closeArchiveEntry();
                Processor.this.console.info("link:" + entry.getName() + " linkname:" + entry.getLinkName());
            }

            private String fixPath(String path) {
                if (path.indexOf(92) > -1) {
                    path = path.replace('\\', '/');
                }
                if (path.startsWith("/")) {
                    path = "." + path;
                } else if (!path.startsWith("./")) {
                    path = "./" + path;
                }
                return path;
            }

            private void createDirectory(String directory, String user, int uid, String group, int gid, int mode, long size) throws IOException {
                if (!directory.endsWith("/")) {
                    directory = directory + "/";
                }
                if (!addedDirectories.contains(directory)) {
                    TarArchiveEntry entry = new TarArchiveEntry(directory, true);
                    entry.setUserName(user);
                    entry.setUserId(uid);
                    entry.setGroupName(group);
                    entry.setGroupId(gid);
                    entry.setMode(mode);
                    entry.setSize(size);
                    tarOutputStream.putArchiveEntry(entry);
                    tarOutputStream.closeArchiveEntry();
                    addedDirectories.add(directory);
                }
            }

            private void createParentDirectories(String dirname, String user, int uid, String group, int gid) throws IOException {
                if (dirname == null) {
                    return;
                }
                String[] pathParts = dirname.split("\\/");
                String parentDir = "./";
                for (int i = 1; i < pathParts.length; ++i) {
                    parentDir = parentDir + pathParts[i] + "/";
                    int mode = 16877;
                    this.createDirectory(parentDir, user, uid, group, gid, mode, 0L);
                }
            }
        };
        try {
            for (int i = 0; i < pData.length; ++i) {
                DataProducer data = pData[i];
                data.produce(receiver);
            }
        }
        finally {
            tarOutputStream.close();
        }
        this.console.info("Total size: " + dataSize);
        return dataSize.count;
    }

    private static void addEntry(String pName, String pContent, TarArchiveOutputStream pOutput) throws IOException {
        byte[] data = pContent.getBytes("UTF-8");
        TarArchiveEntry entry = new TarArchiveEntry("./" + pName, true);
        entry.setSize(data.length);
        entry.setNames("root", "root");
        pOutput.putArchiveEntry(entry);
        pOutput.write(data);
        pOutput.closeArchiveEntry();
    }

    private static void addControlEntry(String pName, String pContent, TarArchiveOutputStream pOutput) throws IOException {
        byte[] data = pContent.getBytes("UTF-8");
        TarArchiveEntry entry = new TarArchiveEntry("./" + pName, true);
        entry.setSize(data.length);
        entry.setNames("root", "root");
        entry.setMode(PermMapper.toMode("755"));
        pOutput.putArchiveEntry(entry);
        pOutput.write(data);
        pOutput.closeArchiveEntry();
    }

    private static final class Total {
        private BigInteger count = BigInteger.valueOf(0L);

        private Total() {
        }

        public void add(long size) {
            this.count = this.count.add(BigInteger.valueOf(size));
        }

        public String toString() {
            return "" + this.count;
        }
    }
}

