/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.changes;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.vafer.jdeb.changes.ChangeSet;
import org.vafer.jdeb.changes.ChangesProvider;
import org.vafer.jdeb.descriptors.PackageDescriptor;

public final class TextfileChangesProvider
implements ChangesProvider {
    private final ChangeSet[] changeSets;

    public TextfileChangesProvider(InputStream pInput, PackageDescriptor pDescriptor) throws IOException, ParseException {
        ChangeSet changeSet;
        String[] changes;
        ArrayList<ChangeSet> changeSetColl;
        ArrayList<String> changesColl;
        String changedBy;
        String urgency;
        String distribution;
        Date date;
        String version;
        String packageName;
        BufferedReader reader;
        block13: {
            String line;
            reader = new BufferedReader(new InputStreamReader(pInput));
            SimpleDateFormat tdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
            DateFormat sdf = ChangeSet.createDateForma();
            packageName = pDescriptor.get("Package");
            version = pDescriptor.get("Version");
            date = tdf.parse(pDescriptor.get("Date"));
            distribution = pDescriptor.get("Distribution");
            urgency = pDescriptor.get("Urgency");
            changedBy = pDescriptor.get("Maintainer");
            changesColl = new ArrayList<String>();
            changeSetColl = new ArrayList<ChangeSet>();
            block0: while (true) {
                if ((line = reader.readLine()) == null) break block13;
                if (line.startsWith("release ")) {
                    String[] tokens;
                    if (changesColl.size() > 0) {
                        changes = changesColl.toArray(new String[changesColl.size()]);
                        changeSet = new ChangeSet(packageName, version, date, distribution, urgency, changedBy, changes);
                        changeSetColl.add(changeSet);
                        changesColl.clear();
                    }
                    String[] arr$ = tokens = line.substring("release ".length()).split(",");
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block0;
                        String token = arr$[i$];
                        String[] lr = token.trim().split("=");
                        String key = lr[0];
                        String value = lr[1];
                        if ("urgency".equals(key)) {
                            urgency = value;
                        } else if ("by".equals(key)) {
                            changedBy = value;
                        } else if ("date".equals(key)) {
                            date = sdf.parse(value);
                        } else if ("version".equals(key)) {
                            version = value;
                        } else if ("distribution".equals(key)) {
                            distribution = value;
                        }
                        ++i$;
                    }
                }
                if (!line.startsWith(" * ")) break;
                changesColl.add(line.substring(" * ".length()));
            }
            throw new ParseException("Unknown line syntax [" + line + "]", 0);
        }
        changes = changesColl.toArray(new String[changesColl.size()]);
        changeSet = new ChangeSet(packageName, version, date, distribution, urgency, changedBy, changes);
        changeSetColl.add(changeSet);
        reader.close();
        this.changeSets = changeSetColl.toArray(new ChangeSet[changeSetColl.size()]);
    }

    public void save(OutputStream pOutput) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(pOutput));
        DateFormat df = ChangeSet.createDateForma();
        for (ChangeSet changeSet : this.changeSets) {
            writer.write("release ");
            writer.write("date=" + df.format(changeSet.getDate()) + ",");
            writer.write("version=" + changeSet.getVersion() + ",");
            writer.write("urgency=" + changeSet.getUrgency() + ",");
            writer.write("by=" + changeSet.getChangedBy() + ",");
            writer.write("distribution=" + changeSet.getDistribution());
            writer.write("\n");
            for (String change : changeSet.getChanges()) {
                writer.write(" * ");
                writer.write(change);
                writer.write("\n");
            }
        }
        writer.close();
    }

    @Override
    public ChangeSet[] getChangesSets() {
        return this.changeSets;
    }
}

