/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.control;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public class FilteredConfigurationFile {
    private static String openToken = "[[";
    private static String closeToken = "]]";
    private List<String> lines = new ArrayList<String>();
    private String name;

    public FilteredConfigurationFile(String name, InputStream pInputStream, VariableResolver pResolver) throws IOException {
        this.name = name;
        this.parse(pInputStream, pResolver);
    }

    public static void setOpenToken(String pToken) {
        openToken = pToken;
    }

    public static void setCloseToken(String pToken) {
        closeToken = pToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream pInputStream, VariableResolver pResolver) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(pInputStream));
            while ((line = br.readLine()) != null) {
                this.lines.add(Utils.replaceVariables(pResolver, line, openToken, closeToken));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String line : this.lines) {
            builder.append(line).append('\n');
        }
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }
}

