/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.signing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;

public final class SigningUtils {
    private static final byte[] EOL = "\r\n".getBytes(Charset.forName("UTF-8"));

    public static void clearSign(InputStream input, InputStream keyring, String keyId, String passphrase, OutputStream output) throws IOException, PGPException, GeneralSecurityException {
        String line;
        PGPSecretKey secretKey = SigningUtils.getSecretKey(keyring, keyId);
        PGPPrivateKey privateKey = secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passphrase.toCharArray()));
        int digest = 2;
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), digest));
        signatureGenerator.init(1, privateKey);
        ArmoredOutputStream armoredOutput = new ArmoredOutputStream(output);
        armoredOutput.beginClearText(digest);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            byte[] data = SigningUtils.trim(line).getBytes("UTF-8");
            armoredOutput.write(data);
            armoredOutput.write(EOL);
            signatureGenerator.update(data);
            signatureGenerator.update(EOL);
        }
        armoredOutput.endClearText();
        PGPSignature signature = signatureGenerator.generate();
        signature.encode((OutputStream)new BCPGOutputStream((OutputStream)armoredOutput));
        armoredOutput.close();
    }

    private static PGPSecretKey getSecretKey(InputStream input, String keyId) throws IOException, PGPException {
        PGPSecretKeyRingCollection keyrings = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input));
        Iterator rIt = keyrings.getKeyRings();
        while (rIt.hasNext()) {
            PGPSecretKeyRing kRing = (PGPSecretKeyRing)rIt.next();
            Iterator kIt = kRing.getSecretKeys();
            while (kIt.hasNext()) {
                PGPSecretKey key = (PGPSecretKey)kIt.next();
                if (!key.isSigningKey() || !Long.toHexString(key.getKeyID() & 0xFFFFFFFFL).equals(keyId.toLowerCase())) continue;
                return key;
            }
        }
        return null;
    }

    private static String trim(String line) {
        int len;
        char[] chars = line.toCharArray();
        for (len = chars.length; len > 0 && Character.isWhitespace(chars[len - 1]); --len) {
        }
        return line.substring(0, len);
    }
}

