/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.busmods;

import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.deploy.Verticle;

public abstract class BusModBase
extends Verticle {
    protected EventBus eb;
    protected JsonObject config;
    protected Logger logger;

    @Override
    public void start() {
        this.eb = this.vertx.eventBus();
        this.config = this.container.getConfig();
        this.logger = this.container.getLogger();
    }

    protected void sendOK(Message<JsonObject> message) {
        this.sendOK(message, null);
    }

    protected void sendStatus(String status, Message<JsonObject> message) {
        this.sendStatus(status, message, null);
    }

    protected void sendStatus(String status, Message<JsonObject> message, JsonObject json) {
        if (json == null) {
            json = new JsonObject();
        }
        json.putString("status", status);
        message.reply((Object)json);
    }

    protected void sendOK(Message<JsonObject> message, JsonObject json) {
        this.sendStatus("ok", message, json);
    }

    protected void sendError(Message<JsonObject> message, String error) {
        this.sendError(message, error, null);
    }

    protected void sendError(Message<JsonObject> message, String error, Exception e) {
        this.logger.error((Object)error, (Throwable)e);
        JsonObject json = new JsonObject().putString("status", "error").putString("message", error);
        message.reply((Object)json);
    }

    protected String getMandatoryString(String field, Message<JsonObject> message) {
        String val = ((JsonObject)message.body).getString(field);
        if (val == null) {
            this.sendError(message, field + " must be specified");
        }
        return val;
    }

    protected JsonObject getMandatoryObject(String field, Message<JsonObject> message) {
        JsonObject val = ((JsonObject)message.body).getObject(field);
        if (val == null) {
            this.sendError(message, field + " must be specified");
        }
        return val;
    }

    protected boolean getOptionalBooleanConfig(String fieldName, boolean defaultValue) {
        Boolean b = this.config.getBoolean(fieldName);
        return b == null ? defaultValue : b;
    }

    protected String getOptionalStringConfig(String fieldName, String defaultValue) {
        String b = this.config.getString(fieldName);
        return b == null ? defaultValue : b;
    }

    protected int getOptionalIntConfig(String fieldName, int defaultValue) {
        Integer b = (Integer)this.config.getNumber(fieldName);
        return b == null ? defaultValue : b;
    }

    protected long getOptionalLongConfig(String fieldName, long defaultValue) {
        Long l = (Long)this.config.getNumber(fieldName);
        return l == null ? defaultValue : l;
    }

    protected JsonObject getOptionalObjectConfig(String fieldName, JsonObject defaultValue) {
        JsonObject o = this.config.getObject(fieldName);
        return o == null ? defaultValue : o;
    }

    protected JsonArray getOptionalArrayConfig(String fieldName, JsonArray defaultValue) {
        JsonArray a = this.config.getArray(fieldName);
        return a == null ? defaultValue : a;
    }

    protected boolean getMandatoryBooleanConfig(String fieldName) {
        Boolean b = this.config.getBoolean(fieldName);
        if (b == null) {
            throw new IllegalArgumentException(fieldName + " must be specified in config for busmod");
        }
        return b;
    }

    protected String getMandatoryStringConfig(String fieldName) {
        String s = this.config.getString(fieldName);
        if (s == null) {
            throw new IllegalArgumentException(fieldName + " must be specified in config for busmod");
        }
        return s;
    }

    protected int getMandatoryIntConfig(String fieldName) {
        Integer i = (Integer)this.config.getNumber(fieldName);
        if (i == null) {
            throw new IllegalArgumentException(fieldName + " must be specified in config for busmod");
        }
        return i;
    }

    protected long getMandatoryLongConfig(String fieldName) {
        Long l = (Long)this.config.getNumber(fieldName);
        if (l == null) {
            throw new IllegalArgumentException(fieldName + " must be specified in config for busmod");
        }
        return l;
    }
}

