/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.deploy;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.vertx.java.core.Handler;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.deploy.impl.VerticleManager;

public class Container {
    private final VerticleManager mgr;

    public Container(VerticleManager mgr) {
        this.mgr = mgr;
    }

    public void deployWorkerVerticle(String main) {
        this.deployWorkerVerticle(main, null, 1);
    }

    public void deployWorkerVerticle(String main, int instances) {
        this.deployWorkerVerticle(main, null, instances);
    }

    public void deployWorkerVerticle(String main, JsonObject config) {
        this.deployWorkerVerticle(main, config, 1);
    }

    public void deployWorkerVerticle(String main, JsonObject config, int instances) {
        this.deployWorkerVerticle(main, config, instances, null);
    }

    public void deployWorkerVerticle(String main, JsonObject config, int instances, Handler<String> doneHandler) {
        URL[] currURLs = this.mgr.getDeploymentURLs();
        File modDir = this.mgr.getDeploymentModDir();
        this.mgr.deployVerticle(true, main, config, currURLs, instances, modDir, null, doneHandler);
    }

    public void deployModule(String moduleName) {
        this.deployModule(moduleName, null, 1);
    }

    public void deployModule(String moduleName, int instances) {
        this.deployModule(moduleName, null, instances);
    }

    public void deployModule(String moduleName, JsonObject config) {
        this.deployModule(moduleName, config, 1);
    }

    public void deployModule(String moduleName, JsonObject config, int instances) {
        this.deployModule(moduleName, config, instances, null);
    }

    public void deployModule(String moduleName, JsonObject config, int instances, Handler<String> doneHandler) {
        File modDir = this.mgr.getDeploymentModDir();
        this.mgr.deployMod(moduleName, config, instances, modDir, doneHandler);
    }

    public void deployVerticle(String main) {
        this.deployVerticle(main, null, 1);
    }

    public void deployVerticle(String main, int instances) {
        this.deployVerticle(main, null, instances);
    }

    public void deployVerticle(String main, JsonObject config) {
        this.deployVerticle(main, config, 1);
    }

    public void deployVerticle(String main, JsonObject config, int instances) {
        this.deployVerticle(main, config, instances, null);
    }

    public void deployVerticle(String main, JsonObject config, int instances, Handler<String> doneHandler) {
        URL[] currURLs = this.mgr.getDeploymentURLs();
        File modDir = this.mgr.getDeploymentModDir();
        this.mgr.deployVerticle(false, main, config, currURLs, instances, modDir, null, doneHandler);
    }

    public void undeployVerticle(String deploymentID) {
        this.undeployVerticle(deploymentID, null);
    }

    public void undeployVerticle(String deploymentID, Handler<Void> doneHandler) {
        this.mgr.undeploy(deploymentID, doneHandler);
    }

    public void undeployModule(String deploymentID) {
        this.undeployModule(deploymentID, null);
    }

    public void undeployModule(String deploymentID, Handler<Void> doneHandler) {
        this.mgr.undeploy(deploymentID, doneHandler);
    }

    public JsonObject getConfig() {
        return this.mgr.getConfig();
    }

    public Logger getLogger() {
        return this.mgr.getLogger();
    }

    public void exit() {
        this.mgr.unblock();
    }

    public Map<String, String> getEnv() {
        return System.getenv();
    }
}

