/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.misc.behaviors;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeBehavior
implements IBehavior,
IHeaderContributor {
    private Iterable<IBehavior> behaviors_;

    public CompositeBehavior(IBehavior ... behaviors) {
        this(Arrays.asList(behaviors));
    }

    public CompositeBehavior(Iterable<IBehavior> behaviors) {
        this.behaviors_ = behaviors;
    }

    public void exception(Component aComponent, RuntimeException aException) {
        for (IBehavior behavior : this.behaviors_) {
            behavior.exception(aComponent, aException);
        }
    }

    public void onComponentTag(Component aComponent, ComponentTag aTag) {
        for (IBehavior behavior : this.behaviors_) {
            behavior.onComponentTag(aComponent, aTag);
        }
    }

    public void afterRender(Component arg0) {
        for (IBehavior behavior : this.behaviors_) {
            behavior.afterRender(arg0);
        }
    }

    public void beforeRender(Component arg0) {
        for (IBehavior behavior : this.behaviors_) {
            behavior.beforeRender(arg0);
        }
    }

    public void bind(Component arg0) {
        for (IBehavior behavior : this.behaviors_) {
            behavior.bind(arg0);
        }
    }

    public void detach(Component arg0) {
        for (IBehavior behavior : this.behaviors_) {
            behavior.detach(arg0);
        }
    }

    public boolean getStatelessHint(Component arg0) {
        boolean back = true;
        for (IBehavior behavior : this.behaviors_) {
            back = back && behavior.getStatelessHint(arg0);
        }
        return back;
    }

    public boolean isEnabled(Component arg0) {
        boolean back = true;
        for (IBehavior behavior : this.behaviors_) {
            back = back && behavior.isEnabled(arg0);
        }
        return back;
    }

    public boolean isTemporary() {
        boolean back = true;
        for (IBehavior behavior : this.behaviors_) {
            back = back && behavior.isTemporary();
        }
        return back;
    }

    public void renderHead(IHeaderResponse arg0) {
        for (IBehavior behavior : this.behaviors_) {
            if (!(behavior instanceof IHeaderContributor)) continue;
            ((IHeaderContributor)behavior).renderHead(arg0);
        }
    }
}

