/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.misc.filters;

import java.net.InetAddress;
import org.apache.wicket.IResponseFilter;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public class ServerHostNameAndTimeFilter
implements IResponseFilter {
    private String host;

    public ServerHostNameAndTimeFilter() throws Exception {
        this(System.getProperty("hostid"));
    }

    public ServerHostNameAndTimeFilter(String hostId) throws Exception {
        InetAddress localMachine = InetAddress.getLocalHost();
        String hostName = localMachine.getHostName();
        String address = localMachine.getHostAddress();
        this.host = (!Strings.isEmpty((CharSequence)hostName) ? hostName + "/" + address : address) + "/" + hostId;
        if (Strings.isEmpty((CharSequence)hostId)) {
            this.host = "<unknown>";
        }
    }

    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        int index = responseBuffer.indexOf("<head>");
        long timeTaken = System.currentTimeMillis() - RequestCycle.get().getStartTime();
        if (index != -1) {
            AppendingStringBuffer script = new AppendingStringBuffer(75);
            script.append("\n");
            script.append("<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\n");
            script.append("\n\twindow.defaultStatus='");
            script.append("Host: ");
            script.append(this.host);
            script.append(", handled in: ");
            script.append((Object)Duration.milliseconds((long)timeTaken));
            script.append("';\n");
            script.append("\n/*-->]]>*/</script>\n");
            script.append("\n");
            responseBuffer.insert(index + 6, (Object)script);
        }
        return responseBuffer;
    }
}

