/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree.table;

import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tree.table.AbstractColumnsView;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;

final class SideColumnsView
extends AbstractColumnsView {
    private static final long serialVersionUID = 1L;

    public SideColumnsView(String id, TreeNode node) {
        super(id, node);
        this.setRenderBodyOnly(true);
    }

    @Override
    public void addColumn(IColumn column, Component component, IRenderable renderable) {
        AbstractColumnsView.Position position = column.getLocation().getAlignment() == ColumnLocation.Alignment.LEFT ? AbstractColumnsView.Position.APPEND : AbstractColumnsView.Position.PREPEND;
        super.addColumn(column, component, renderable, position);
    }

    protected void onRender() {
        Response response = RequestCycle.get().getResponse();
        boolean firstLeft = true;
        for (int i = 0; i < this.columns.size(); ++i) {
            IColumn column = (IColumn)this.columns.get(i);
            Component component = (Component)this.components.get(i);
            IRenderable renderable = (IRenderable)this.renderables.get(i);
            response.write((CharSequence)("<span class=\"b_\" style=\"" + this.renderColumnStyle(column) + "\">"));
            if (column.getLocation().getAlignment() == ColumnLocation.Alignment.LEFT && firstLeft) {
                response.write((CharSequence)"<span class=\"d_\">");
                firstLeft = false;
            } else {
                response.write((CharSequence)"<span class=\"c_\">");
            }
            if (component != null) {
                component.render();
            } else if (renderable != null) {
                renderable.render(this.node, response);
            } else {
                throw new IllegalStateException("Either renderable or cell component must be created for this node");
            }
            response.write((CharSequence)"</span></span>\n");
        }
    }

    public IMarkupFragment getMarkup(Component child) {
        return this.getMarkup();
    }

    private String renderColumnFloat(IColumn column) {
        ColumnLocation location = column.getLocation();
        if (location.getAlignment() == ColumnLocation.Alignment.LEFT) {
            return "left";
        }
        if (location.getAlignment() == ColumnLocation.Alignment.RIGHT) {
            return "right";
        }
        throw new IllegalStateException("Wrong column allignment.");
    }

    private String renderColumnStyle(IColumn column) {
        return "width:" + this.renderColumnWidth(column) + ";float:" + this.renderColumnFloat(column);
    }

    private String renderColumnWidth(IColumn column) {
        ColumnLocation location = column.getLocation();
        return "" + location.getSize() + this.renderUnit(location.getUnit());
    }

    private String renderUnit(ColumnLocation.Unit unit) {
        if (unit == ColumnLocation.Unit.EM) {
            return "em";
        }
        if (unit == ColumnLocation.Unit.PX) {
            return "px";
        }
        if (unit == ColumnLocation.Unit.PERCENT) {
            return "%";
        }
        throw new IllegalStateException("Wrong column unit for column aligned left or right.");
    }
}

