/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree.table;

import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tree.DefaultAbstractTree;
import org.apache.wicket.extensions.markup.html.tree.WicketTreeModel;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.extensions.markup.html.tree.table.MiddleColumnsView;
import org.apache.wicket.extensions.markup.html.tree.table.SideColumnsView;
import org.apache.wicket.extensions.markup.html.tree.table.TreeTableItem;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IClusterable;

@Deprecated
public class TreeTable
extends DefaultAbstractTree {
    private static final ResourceReference CSS = new CssResourceReference(DefaultAbstractTree.class, "res/tree-table.css");
    private static final long serialVersionUID = 1L;
    private final IColumn[] columns;

    public static Component newTreeCell(MarkupContainer parent, String id, TreeNode node, int level, IRenderNodeCallback callback, TreeTable table) {
        return table.newTreePanel(parent, id, node, level, callback);
    }

    public TreeTable(String id, IColumn[] columns) {
        this(id, (TreeModel)null, columns);
    }

    public TreeTable(String id, TreeModel model, IColumn[] columns) {
        this(id, (IModel<? extends TreeModel>)new WicketTreeModel(model), columns);
    }

    public TreeTable(String id, IModel<? extends TreeModel> model, IColumn[] columns) {
        super(id, model);
        this.columns = columns;
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("Wicket.TreeTable.attachUpdate(\"" + TreeTable.this.getMarkupId() + "\")")));
            }
        }});
    }

    private boolean hasLeftColumn() {
        for (IColumn column : this.columns) {
            if (!column.getLocation().getAlignment().equals((Object)ColumnLocation.Alignment.LEFT)) continue;
            return true;
        }
        return false;
    }

    protected void addHeader() {
        SideColumnsView sideColumns = new SideColumnsView("sideHeaderColumns", null);
        this.add(new Component[]{sideColumns});
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.LEFT && column.getLocation().getAlignment() != ColumnLocation.Alignment.RIGHT) continue;
                TreeTableItem component = new TreeTableItem(i);
                Component cell = column.newHeader((MarkupContainer)sideColumns, "comp");
                component.add(new Component[]{cell});
                sideColumns.addColumn(column, (Component)component, null);
            }
        }
        MiddleColumnsView middleColumns = new MiddleColumnsView("middleHeaderColumns", null, this.hasLeftColumn());
        this.add(new Component[]{middleColumns});
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.MIDDLE) continue;
                TreeTableItem component = new TreeTableItem(i);
                Component cell = column.newHeader((MarkupContainer)middleColumns, "comp");
                component.add(new Component[]{cell});
                middleColumns.addColumn(column, (Component)component, null);
            }
        }
    }

    @Override
    protected ResourceReference getCSS() {
        return CSS;
    }

    protected Component newTreePanel(MarkupContainer parent, String id, TreeNode node, int level, IRenderNodeCallback renderNodeCallback) {
        return new TreeFragment(id, node, level, renderNodeCallback);
    }

    @Override
    protected void onBeforeAttach() {
        if (this.get("sideHeaderColumns") == null) {
            if (this.columns != null) {
                for (IColumn column : this.columns) {
                    column.setTreeTable(this);
                }
            }
            this.addHeader();
        }
    }

    @Override
    protected void populateTreeItem(WebMarkupContainer item, int level) {
        final TreeNode node = (TreeNode)item.getDefaultModelObject();
        SideColumnsView sideColumns = new SideColumnsView("sideBodyColumns", node);
        item.add(new Component[]{sideColumns});
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                TreeTableItem component;
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.LEFT && column.getLocation().getAlignment() != ColumnLocation.Alignment.RIGHT) continue;
                IRenderable renderable = column.newCell(node, level);
                if (renderable == null) {
                    component = new TreeTableItem(i);
                    Component cell = column.newCell((MarkupContainer)sideColumns, "comp", node, level);
                    component.add(new Component[]{cell});
                } else {
                    component = null;
                }
                sideColumns.addColumn(column, (Component)component, renderable);
            }
        }
        MiddleColumnsView middleColumns = new MiddleColumnsView("middleBodyColumns", node, this.hasLeftColumn());
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                TreeTableItem component;
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.MIDDLE) continue;
                IRenderable renderable = column.newCell(node, level);
                if (renderable == null) {
                    component = new TreeTableItem(i);
                    Component cell = column.newCell((MarkupContainer)middleColumns, "comp", node, level);
                    component.add(new Component[]{cell});
                } else {
                    component = null;
                }
                middleColumns.addColumn(column, (Component)component, renderable);
            }
        }
        item.add(new Component[]{middleColumns});
        item.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                if (TreeTable.this.getTreeState().isNodeSelected(node)) {
                    tag.put("class", (CharSequence)"row-selected");
                } else {
                    tag.put("class", (CharSequence)"row");
                }
            }
        }});
    }

    private class TreeFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public TreeFragment(String id, final TreeNode node, int level, final IRenderNodeCallback renderNodeCallback) {
            super(id, "fragment", (MarkupContainer)TreeTable.this);
            this.add(new Component[]{TreeTable.this.newIndentation((MarkupContainer)this, "indent", node, level)});
            this.add(new Component[]{TreeTable.this.newJunctionLink((MarkupContainer)this, "link", "image", node)});
            MarkupContainer nodeLink = TreeTable.this.newNodeLink((MarkupContainer)this, "nodeLink", node);
            this.add(new Component[]{nodeLink});
            nodeLink.add(new Component[]{TreeTable.this.newNodeIcon(nodeLink, "icon", node)});
            nodeLink.add(new Component[]{new Label("label", (IModel)new AbstractReadOnlyModel<String>(){
                private static final long serialVersionUID = 1L;

                public String getObject() {
                    return renderNodeCallback.renderNode(node);
                }
            })});
        }
    }

    public static interface IRenderNodeCallback
    extends IClusterable {
        public String renderNode(TreeNode var1);
    }
}

