/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.event.container.AfterUnDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.logging.Logger;

public class ServerSetupObserver {
    private static final Logger log = Logger.getLogger(ServerSetupObserver.class);
    @Inject
    private Instance<ManagementClient> managementClient;
    @Inject
    private Instance<ClassContext> classContextInstance;
    private final List<ServerSetupTask> setupTasksAll = new ArrayList<ServerSetupTask>();
    private final List<ServerSetupTask> setupTasksInForce = new ArrayList<ServerSetupTask>();
    private final Map<String, ManagementClient> active = new HashMap<String, ManagementClient>();
    private Map<String, Integer> deployed;
    boolean afterClassRun = false;

    public synchronized void handleBeforeDeployment(@Observes BeforeDeploy event, Container container) throws Throwable {
        int index;
        if (this.deployed == null) {
            this.deployed = new HashMap<String, Integer>();
            this.setupTasksAll.clear();
            this.setupTasksInForce.clear();
            this.afterClassRun = false;
        }
        if (this.deployed.containsKey(container.getName())) {
            this.deployed.put(container.getName(), this.deployed.get(container.getName()) + 1);
        } else {
            this.deployed.put(container.getName(), 1);
        }
        if (this.active.containsKey(container.getName())) {
            return;
        }
        ClassContext classContext = (ClassContext)this.classContextInstance.get();
        if (classContext == null) {
            return;
        }
        Class currentClass = (Class)classContext.getActiveId();
        ContainerClassHolder holder = new ContainerClassHolder(container.getName(), currentClass);
        ServerSetup setup = currentClass.getAnnotation(ServerSetup.class);
        if (setup == null) {
            return;
        }
        Class<? extends ServerSetupTask>[] classes = setup.value();
        if (this.setupTasksAll.isEmpty()) {
            for (Class<? extends ServerSetupTask> clazz : classes) {
                Constructor<? extends ServerSetupTask> ctor = clazz.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                this.setupTasksAll.add(ctor.newInstance(new Object[0]));
            }
        } else {
            for (int i = 0; i < this.setupTasksAll.size(); ++i) {
                if (classes[i] == this.setupTasksAll.get(i).getClass()) continue;
                throw new RuntimeException("Mismatched ServerSetupTask current is " + this.setupTasksAll + " but " + currentClass + " is expecting " + Arrays.asList(classes));
            }
        }
        ManagementClient client = (ManagementClient)this.managementClient.get();
        try {
            for (index = 0; index < this.setupTasksAll.size(); ++index) {
                ServerSetupTask instance = this.setupTasksAll.get(index);
                this.setupTasksInForce.add(instance);
                instance.setup(client, container.getName());
            }
        }
        catch (Throwable e) {
            log.error((Object)("Setup task failed during setup. Offending class '" + this.setupTasksAll.get(index) + "'"), e);
        }
        this.active.put(container.getName(), client);
    }

    public synchronized void afterTestClass(@Observes AfterClass afterClass) throws Exception {
        if (this.deployed == null) {
            return;
        }
        Iterator<Map.Entry<String, Integer>> it = this.deployed.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Integer> container = it.next();
            if (container.getValue() != 0) continue;
            if (this.active.containsKey(container.getKey())) {
                ManagementClient client = this.active.get(container.getKey());
                for (int i = this.setupTasksInForce.size() - 1; i >= 0; --i) {
                    try {
                        this.setupTasksInForce.get(i).tearDown(client, container.getKey());
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("Setup task failed during tear down. Offending class '" + this.setupTasksAll.get(i) + "'"), (Throwable)e);
                    }
                }
            }
            this.active.remove(container.getKey());
            it.remove();
        }
        this.afterClassRun = true;
        if (this.deployed.isEmpty()) {
            this.deployed = null;
            this.setupTasksAll.clear();
            this.setupTasksInForce.clear();
            this.afterClassRun = false;
        }
    }

    public synchronized void handleAfterUndeploy(@Observes AfterUnDeploy afterDeploy, Container container) throws Exception {
        if (this.deployed == null) {
            return;
        }
        Integer count = this.deployed.get(container.getName());
        if (count == null) {
            log.debugf("No deployments found for container %s.", (Object)container.getName());
            return;
        }
        count = count - 1;
        this.deployed.put(container.getName(), count);
        if (count == 0 && this.afterClassRun) {
            for (int i = this.setupTasksInForce.size() - 1; i >= 0; --i) {
                try {
                    this.setupTasksInForce.get(i).tearDown((ManagementClient)this.managementClient.get(), container.getName());
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Setup task failed during tear down. Offending class '" + this.setupTasksAll.get(i) + "'"), (Throwable)e);
                }
            }
            this.active.remove(container.getName());
            this.deployed.remove(container.getName());
        }
        if (this.deployed.isEmpty()) {
            this.deployed = null;
            this.setupTasksAll.clear();
            this.setupTasksInForce.clear();
            this.afterClassRun = false;
        }
    }

    private static final class ContainerClassHolder {
        private final Class<?> testClass;
        private final String name;

        private ContainerClassHolder(String name, Class<?> testClass) {
            this.name = name;
            this.testClass = testClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContainerClassHolder that = (ContainerClassHolder)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.testClass != null ? !this.testClass.equals(that.testClass) : that.testClass != null);
        }

        public int hashCode() {
            int result = this.testClass != null ? this.testClass.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

