/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.IOException;
import org.jboss.as.arquillian.container.ContainerDescription;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

class StandardContainerDescription
implements ContainerDescription {
    static final StandardContainerDescription NULL_DESCRIPTION = new StandardContainerDescription("WildFly", null, null, null);
    private final String productName;
    private final String productVersion;
    private final String releaseCodename;
    private final String releaseVersion;

    private StandardContainerDescription(String productName, String productVersion, String releaseCodename, String releaseVersion) {
        this.productName = productName;
        this.productVersion = productVersion;
        this.releaseCodename = releaseCodename;
        this.releaseVersion = releaseVersion;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    public String getReleaseCodename() {
        return this.releaseCodename;
    }

    @Override
    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(64);
        result.append(this.productName);
        if (this.productVersion != null) {
            result.append(' ').append(this.productVersion);
            if (this.releaseCodename != null) {
                result.append(' ').append('\"').append(this.releaseCodename).append('\"');
            }
            if (this.releaseVersion != null) {
                result.append(" (WildFly Core ").append(this.releaseVersion).append(')');
            }
        } else {
            if (this.releaseVersion != null) {
                result.append(' ').append(this.releaseVersion);
            }
            if (this.releaseCodename != null) {
                result.append(' ').append('\"').append(this.releaseCodename).append('\"');
            }
        }
        return result.toString();
    }

    public static StandardContainerDescription lookup(ManagementClient client) throws IOException {
        ModelNode op = Operations.createReadResourceOperation((ModelNode)new ModelNode().setEmptyList());
        ModelNode result = client.getControllerClient().execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            ModelNode model = Operations.readResult((ModelNode)result);
            String productName = model.hasDefined("product-name") ? model.get("product-name").asString() : "WildFly";
            String productVersion = null;
            if (model.hasDefined("product-version")) {
                productVersion = model.get("product-version").asString();
            }
            String releaseCodename = null;
            if (model.hasDefined("release-codename")) {
                releaseCodename = model.get("release-codename").asString();
            }
            String releaseVersion = null;
            if (model.hasDefined("release-version")) {
                releaseVersion = model.get("release-version").asString();
            }
            return new StandardContainerDescription(productName, productVersion, releaseCodename, releaseVersion);
        }
        Logger.getLogger(StandardContainerDescription.class).errorf("Failed to read the root resource: ", (Object)Operations.getFailureDescription((ModelNode)result));
        return NULL_DESCRIPTION;
    }
}

